/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbOw = new Metadata();
    private ByteBuffer zzbOx = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbOw;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzTP();
        }
        return this.zzbOx;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzTP() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzrC;
        private int zzrD;
        private int mId;
        private long zzbdJ;
        private int zzMA;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzrC = metadata.getWidth();
            this.zzrD = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzbdJ = metadata.getTimestampMillis();
            this.zzMA = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzrC;
        }

        public int getHeight() {
            return this.zzrD;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzbdJ;
        }

        public int getRotation() {
            return this.zzMA;
        }

        public int getFormat() {
            return this.format;
        }

        public void zzTQ() {
            if (this.zzMA % 2 != 0) {
                int n = this.zzrC;
                this.zzrC = this.zzrD;
                this.zzrD = n;
            }
            this.zzMA = 0;
        }
    }

    public static class Builder {
        private Frame zzbOy = new Frame();

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzbOy.mBitmap = bitmap;
            Metadata metadata = this.zzbOy.getMetadata();
            metadata.zzrC = n;
            metadata.zzrD = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzbOy.zzbOx = byteBuffer;
            Metadata metadata = this.zzbOy.getMetadata();
            metadata.zzrC = n;
            metadata.zzrD = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzbOy.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzbOy.getMetadata().zzbdJ = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzbOy.getMetadata().zzMA = n;
            return this;
        }

        public Frame build() {
            if (this.zzbOy.zzbOx == null && this.zzbOy.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbOy;
        }
    }
}

