/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbOm = new Object();
    private Processor<T> zzbOn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbOm;
        synchronized (object) {
            if (this.zzbOn != null) {
                this.zzbOn.release();
                this.zzbOn = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbOm;
        synchronized (object) {
            if (this.zzbOn == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzTQ();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbOn.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbOn = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbOo;
        private Frame.Metadata zzbOp;
        private boolean zzbOq;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbOo = sparseArray;
            this.zzbOp = metadata;
            this.zzbOq = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbOo;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbOp;
        }

        public boolean detectorIsOperational() {
            return this.zzbOq;
        }
    }
}

