/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbOj = new Object();
    private Processor<T> zzbOk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbOj;
        synchronized (object) {
            if (this.zzbOk != null) {
                this.zzbOk.release();
                this.zzbOk = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbOj;
        synchronized (object) {
            if (this.zzbOk == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzTO();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbOk.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbOk = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbOl;
        private Frame.Metadata zzbOm;
        private boolean zzbOn;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbOl = sparseArray;
            this.zzbOm = metadata;
            this.zzbOn = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbOl;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbOm;
        }

        public boolean detectorIsOperational() {
            return this.zzbOn;
        }
    }
}

