/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbjq;
import com.google.android.gms.internal.zzbjt;
import com.google.android.gms.internal.zzbka;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.zza;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zza zzbOS = new zza();
    private final zzbjq zzbOT;
    private final Object zzrJ = new Object();
    private boolean zzbOU = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        super.release();
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.zzbOU) {
                return;
            }
            this.zzbOT.zzTQ();
            this.zzbOU = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzrJ;
            synchronized (object) {
                if (this.zzbOU) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.zzbOU) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzbOT.zzb(byteBuffer, zzbka.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.zzbOS.zznR(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int n) {
        int n2 = this.zzbOS.zznS(n);
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.zzbOU) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzbOT.zzoh(n2);
        }
    }

    @Override
    public boolean isOperational() {
        return this.zzbOT.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzbjq zzbjq2) {
        this.zzbOT = zzbjq2;
    }

    public static class Builder {
        private final Context mContext;
        private int zzbOV = 0;
        private boolean zzbOW = false;
        private int zzbOX = 0;
        private boolean zzbOY = true;
        private int zzaKF = 0;
        private float zzbOZ = -1.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzbOV = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzbOW = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzbOX = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.zzbOY = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.zzaKF = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzbOZ = f;
            return this;
        }

        public FaceDetector build() {
            zzbjt zzbjt2 = new zzbjt();
            zzbjt2.mode = this.zzaKF;
            zzbjt2.zzbPi = this.zzbOV;
            zzbjt2.zzbPj = this.zzbOX;
            zzbjt2.zzbPk = this.zzbOW;
            zzbjt2.zzbPl = this.zzbOY;
            zzbjt2.zzbPm = this.zzbOZ;
            zzbjq zzbjq2 = new zzbjq(this.mContext, zzbjt2);
            return new FaceDetector(zzbjq2);
        }
    }
}

