/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbMy = new Metadata();
    private ByteBuffer zzbMz = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbMy;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzSl();
        }
        return this.zzbMz;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzSl() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzrG;
        private int zzrH;
        private int mId;
        private long zzbde;
        private int zzLS;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzrG = metadata.getWidth();
            this.zzrH = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzbde = metadata.getTimestampMillis();
            this.zzLS = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzrG;
        }

        public int getHeight() {
            return this.zzrH;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzbde;
        }

        public int getRotation() {
            return this.zzLS;
        }

        public int getFormat() {
            return this.format;
        }

        public void zzSm() {
            if (this.zzLS % 2 != 0) {
                int n = this.zzrG;
                this.zzrG = this.zzrH;
                this.zzrH = n;
            }
            this.zzLS = 0;
        }
    }

    public static class Builder {
        private Frame zzbMA = new Frame();

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzbMA.mBitmap = bitmap;
            Metadata metadata = this.zzbMA.getMetadata();
            metadata.zzrG = n;
            metadata.zzrH = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzbMA.zzbMz = byteBuffer;
            Metadata metadata = this.zzbMA.getMetadata();
            metadata.zzrG = n;
            metadata.zzrH = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzbMA.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzbMA.getMetadata().zzbde = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzbMA.getMetadata().zzLS = n;
            return this;
        }

        public Frame build() {
            if (this.zzbMA.zzbMz == null && this.zzbMA.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbMA;
        }
    }
}

