/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzbMd;
    private Tracker<T> zzbMt;
    private int zzbMu = 3;
    private boolean zzbMv = false;
    private int zzbMw;
    private int zzbMx = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzbMd = detector;
        this.zzbMt = tracker;
    }

    @Override
    public void release() {
        this.zzbMt.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzbMx == this.zzbMu) {
                this.zzbMt.onDone();
                this.zzbMv = false;
            } else {
                this.zzbMt.onMissing(detections);
            }
            ++this.zzbMx;
            return;
        }
        this.zzbMx = 0;
        if (this.zzbMv) {
            Object object2 = sparseArray.get(this.zzbMw);
            if (object2 != null) {
                this.zzbMt.onUpdate(detections, object2);
                return;
            }
            this.zzbMt.onDone();
            this.zzbMv = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzbMv = true;
        this.zzbMw = n;
        this.zzbMd.setFocus(this.zzbMw);
        this.zzbMt.onNewItem(this.zzbMw, object);
        this.zzbMt.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected void zznf(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzbMu = n;
    }
}

