/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzbgq zzbMJ;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzbgq zzbgq2) {
        this.zzbMJ = zzbgq2;
    }

    @Override
    public void release() {
        super.release();
        this.zzbMJ.zzSp();
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzbhd zzbhd2 = zzbhd.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbMJ.zza(frame.getBitmap(), zzbhd2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbMJ.zza(byteBuffer, zzbhd2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.zzbMJ.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private zzbgo zzbMK;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbMK = new zzbgo();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbMK.zzbML = n;
            return this;
        }

        public BarcodeDetector build() {
            zzbgq zzbgq2 = new zzbgq(this.mContext, this.zzbMK);
            return new BarcodeDetector(zzbgq2);
        }
    }
}

