/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.internal;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.android.gms.internal.vision.zzfe;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class zzb {
    public static Bitmap zza(ByteBuffer byteBuffer, int n, int n2, int n3) throws IOException {
        byte[] byArray;
        ByteBuffer byteBuffer2 = byteBuffer;
        if (byteBuffer2.hasArray() && byteBuffer2.arrayOffset() == 0) {
            byArray = byteBuffer2.array();
        } else {
            byteBuffer2.rewind();
            byte[] byArray2 = new byte[byteBuffer2.limit()];
            byteBuffer2.get(byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        byte[] byArray3 = zzb.zza(byArray, n, n2);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray3, (int)0, (int)byArray3.length);
        return zzb.zza(bitmap, n3, bitmap.getWidth(), bitmap.getHeight());
    }

    private static byte[] zza(@NonNull byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        YuvImage yuvImage = new YuvImage(byArray, 17, n, n2, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            yuvImage.compressToJpeg(new Rect(0, 0, n, n2), 100, (OutputStream)byteArrayOutputStream);
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable2) {
                zzfe.zza(throwable, throwable2);
            }
            throw throwable;
        }
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static Bitmap zza(Bitmap bitmap, int n, int n2, int n3) {
        if (n == 0) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)true);
    }

    @RequiresApi(value=19)
    public static ByteBuffer zza(Image.Plane[] planeArray, int n, int n2) {
        int n3 = n * n2;
        byte[] byArray = new byte[n3 + 2 * (n3 / 4)];
        int n4 = n2;
        int n5 = n;
        Image.Plane[] planeArray2 = planeArray;
        int n6 = n5 * n4;
        ByteBuffer byteBuffer = planeArray2[1].getBuffer();
        ByteBuffer byteBuffer2 = planeArray2[2].getBuffer();
        int n7 = byteBuffer2.position();
        int n8 = byteBuffer.limit();
        byteBuffer2.position(n7 + 1);
        byteBuffer.limit(n8 - 1);
        boolean bl = byteBuffer2.remaining() == 2 * n6 / 4 - 2 && byteBuffer2.compareTo(byteBuffer) == 0;
        byteBuffer2.position(n7);
        byteBuffer.limit(n8);
        if (bl) {
            planeArray[0].getBuffer().get(byArray, 0, n3);
            ByteBuffer byteBuffer3 = planeArray[1].getBuffer();
            planeArray[2].getBuffer().get(byArray, n3, 1);
            byteBuffer3.get(byArray, n3 + 1, 2 * n3 / 4 - 1);
        } else {
            zzb.zza(planeArray[0], n, n2, byArray, 0, 1);
            zzb.zza(planeArray[1], n, n2, byArray, n3 + 1, 2);
            zzb.zza(planeArray[2], n, n2, byArray, n3, 2);
        }
        return ByteBuffer.wrap(byArray);
    }

    @TargetApi(value=19)
    private static void zza(Image.Plane plane, int n, int n2, byte[] byArray, int n3, int n4) {
        ByteBuffer byteBuffer = plane.getBuffer();
        byteBuffer.rewind();
        int n5 = (byteBuffer.limit() + plane.getRowStride() - 1) / plane.getRowStride();
        if (n5 == 0) {
            return;
        }
        int n6 = n2 / n5;
        int n7 = n / n6;
        int n8 = n3;
        int n9 = 0;
        for (int i = 0; i < n5; ++i) {
            int n10 = n9;
            for (int j = 0; j < n7; ++j) {
                byArray[n8] = byteBuffer.get(n10);
                n8 += n4;
                n10 += plane.getPixelStride();
            }
            n9 += plane.getRowStride();
        }
    }
}

