/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.vision.L;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public abstract class zzt<T> {
    private final Context zza;
    private final Object zzb = new Object();
    private final String zzc;
    private final String zzd;
    private final String zze;
    private boolean zzf = false;
    private boolean zzg = false;
    @GuardedBy(value="lock")
    @Nullable
    private T zzh;

    public zzt(Context context, String string, String string2) {
        this.zza = context;
        this.zzc = string;
        String string3 = String.valueOf("com.google.android.gms.vision.dynamite.");
        String string4 = String.valueOf(string2);
        this.zzd = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        this.zze = string2;
    }

    public final boolean zzb() {
        return this.zzd() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc() {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zzh == null) {
                return;
            }
            try {
                this.zza();
            }
            catch (RemoteException remoteException) {
                Log.e((String)this.zzc, (String)"Could not finalize native handle", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNonNull(value={"context", "thickFeatureName", "featureName"})
    @Nullable
    protected final T zzd(@UnknownInitialization zzt<T> this) {
        Object object = this.zzb;
        synchronized (object) {
            DynamiteModule dynamiteModule;
            block14: {
                if (this.zzh != null) {
                    return this.zzh;
                }
                dynamiteModule = null;
                try {
                    dynamiteModule = DynamiteModule.load((Context)this.zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)this.zzd);
                }
                catch (DynamiteModule.LoadingException loadingException) {
                    String string = String.format("%s.%s", "com.google.android.gms.vision", this.zze);
                    L.d("Cannot load thick client module, fall back to load optional module %s", string);
                    try {
                        dynamiteModule = DynamiteModule.load((Context)this.zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)string);
                    }
                    catch (DynamiteModule.LoadingException loadingException2) {
                        L.e(loadingException2, "Error loading optional module %s", string);
                        if (this.zzf) break block14;
                        L.d("Broadcasting download intent for dependency %s", this.zze);
                        String string2 = this.zze;
                        Intent intent = new Intent();
                        intent.setClassName("com.google.android.gms", "com.google.android.gms.vision.DependencyBroadcastReceiverProxy");
                        Intent intent2 = intent;
                        intent2.putExtra("com.google.android.gms.vision.DEPENDENCIES", string2);
                        intent2.setAction("com.google.android.gms.vision.DEPENDENCY");
                        Intent intent3 = intent2;
                        this.zza.sendBroadcast(intent3);
                        this.zzf = true;
                    }
                }
            }
            if (dynamiteModule != null) {
                try {
                    this.zzh = this.zza(dynamiteModule, this.zza);
                }
                catch (RemoteException | DynamiteModule.LoadingException throwable) {
                    Log.e((String)this.zzc, (String)"Error creating remote native handle", (Throwable)throwable);
                }
            }
            if (!this.zzg && this.zzh == null) {
                Log.w((String)this.zzc, (String)"Native handle not yet available. Reverting to no-op handle.");
                this.zzg = true;
            } else if (this.zzg && this.zzh != null) {
                Log.w((String)this.zzc, (String)"Native handle is now available.");
            }
            return this.zzh;
        }
    }

    @Nullable
    protected abstract T zza(@UnknownInitialization zzt<T> this, DynamiteModule var1, Context var2) throws RemoteException, DynamiteModule.LoadingException;

    protected abstract void zza() throws RemoteException;
}

