/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.vision.zzaw;
import com.google.android.gms.internal.vision.zzax;
import com.google.android.gms.internal.vision.zzay;
import com.google.android.gms.internal.vision.zzaz;
import com.google.android.gms.internal.vision.zzbb;
import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzde;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzau
implements zzay {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzau> zza = new ArrayMap();
    private final ContentResolver zzb;
    private final Uri zzc;
    private final ContentObserver zzd = new zzaw(this, null);
    private final Object zze = new Object();
    private volatile Map<String, String> zzf;
    @GuardedBy(value="this")
    private final List<zzaz> zzg = new ArrayList<zzaz>();
    private static final String[] zzh = new String[]{"key", "value"};

    private zzau(ContentResolver contentResolver, Uri uri) {
        zzde.zza(contentResolver);
        zzde.zza(uri);
        this.zzb = contentResolver;
        this.zzc = uri;
        contentResolver.registerContentObserver(uri, false, this.zzd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzau zza(ContentResolver contentResolver, Uri uri) {
        Class<zzau> clazz = zzau.class;
        synchronized (zzau.class) {
            zzau zzau2 = zza.get(uri);
            if (zzau2 == null) {
                try {
                    zzau2 = new zzau(contentResolver, uri);
                    zza.put(uri, zzau2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzau2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> zzd() {
        Map<String, String> map = this.zzf;
        if (map == null) {
            Object object = this.zze;
            synchronized (object) {
                map = this.zzf;
                if (map == null) {
                    this.zzf = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza() {
        zzau zzau2;
        Object object = this.zze;
        synchronized (object) {
            this.zzf = null;
            zzbi.zza();
        }
        zzau zzau3 = zzau2 = this;
        synchronized (zzau2) {
            Iterator<zzaz> iterator = zzau2.zzg.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzbb.zza(new zzax(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzb() {
        for (zzau zzau2 : zza.values()) {
            zzau2.zzb.unregisterContentObserver(zzau2.zzd);
        }
        zza.clear();
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zzd().get(string2);
    }

    final /* synthetic */ Map zzc() {
        Cursor cursor = this.zzb.query(this.zzc, zzh, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

