/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzjb
extends zzgi<Long>
implements zzik<Long>,
zzjz,
RandomAccess {
    private static final zzjb zzzz = new zzjb(new long[0], 0);
    private long[] zzaaa;
    private int size;

    zzjb() {
        this(new long[10], 0);
    }

    private zzjb(long[] lArray, int n) {
        this.zzaaa = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaaa, n2, this.zzaaa, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzjb)) {
            return super.equals(object);
        }
        zzjb zzjb2 = (zzjb)object;
        if (this.size != zzjb2.size) {
            return false;
        }
        long[] lArray = zzjb2.zzaaa;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzaaa[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzie.zzab(this.zzaaa[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzal(n);
        return this.zzaaa[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzaaa[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(long l) {
        this.zzek();
        if (this.size == this.zzaaa.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaaa, 0, lArray, 0, this.size);
            this.zzaaa = lArray;
        }
        this.zzaaa[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzjb)) {
            return super.addAll(collection);
        }
        zzjb zzjb2 = (zzjb)collection;
        if (zzjb2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzjb2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzjb2.size;
        if (n > this.zzaaa.length) {
            this.zzaaa = Arrays.copyOf(this.zzaaa, n);
        }
        System.arraycopy(zzjb2.zzaaa, 0, this.zzaaa, this.size, zzjb2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaaa[i])) continue;
            System.arraycopy(this.zzaaa, i + 1, this.zzaaa, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        long l = (Long)object;
        zzjb zzjb2 = this;
        zzjb2.zzek();
        zzjb2.zzal(n);
        long l2 = zzjb2.zzaaa[n];
        zzjb2.zzaaa[n] = l;
        return l2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzjb zzjb2 = this;
        zzjb2.zzek();
        zzjb2.zzal(n);
        long l = zzjb2.zzaaa[n];
        if (n < zzjb2.size - 1) {
            System.arraycopy(zzjb2.zzaaa, n + 1, zzjb2.zzaaa, n, zzjb2.size - n - 1);
        }
        --zzjb2.size;
        ++zzjb2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        long l = (Long)object;
        zzjb zzjb2 = this;
        zzjb2.zzek();
        if (n < 0 || n > zzjb2.size) {
            throw new IndexOutOfBoundsException(zzjb2.zzam(n));
        }
        if (zzjb2.size < zzjb2.zzaaa.length) {
            System.arraycopy(zzjb2.zzaaa, n, zzjb2.zzaaa, n + 1, zzjb2.size - n);
        } else {
            long[] lArray = new long[zzjb2.size * 3 / 2 + 1];
            System.arraycopy(zzjb2.zzaaa, 0, lArray, 0, n);
            System.arraycopy(zzjb2.zzaaa, n, lArray, n + 1, zzjb2.size - n);
            zzjb2.zzaaa = lArray;
        }
        zzjb2.zzaaa[n] = l;
        ++zzjb2.size;
        ++zzjb2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzac((Long)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzjb zzjb2 = this;
        if (n2 < zzjb2.size) {
            throw new IllegalArgumentException();
        }
        return new zzjb(Arrays.copyOf(zzjb2.zzaaa, n2), zzjb2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzzz.zzej();
    }
}

