/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhz
extends zzgi<Float>
implements zzik<Float>,
zzjz,
RandomAccess {
    private static final zzhz zzxm = new zzhz(new float[0], 0);
    private float[] zzxn;
    private int size;

    zzhz() {
        this(new float[10], 0);
    }

    private zzhz(float[] fArray, int n) {
        this.zzxn = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzxn, n2, this.zzxn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhz)) {
            return super.equals(object);
        }
        zzhz zzhz2 = (zzhz)object;
        if (this.size != zzhz2.size) {
            return false;
        }
        float[] fArray = zzhz2.zzxn;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzxn[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzxn[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Float)) {
            return -1;
        }
        float f = ((Float)object).floatValue();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzxn[i] != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzu(float f) {
        this.zzek();
        if (this.size == this.zzxn.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzxn, 0, fArray, 0, this.size);
            this.zzxn = fArray;
        }
        this.zzxn[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzhz)) {
            return super.addAll(collection);
        }
        zzhz zzhz2 = (zzhz)collection;
        if (zzhz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhz2.size;
        if (n > this.zzxn.length) {
            this.zzxn = Arrays.copyOf(this.zzxn, n);
        }
        System.arraycopy(zzhz2.zzxn, 0, this.zzxn, this.size, zzhz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzxn[i]))) continue;
            System.arraycopy(this.zzxn, i + 1, this.zzxn, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        float f = ((Float)object).floatValue();
        zzhz zzhz2 = this;
        zzhz2.zzek();
        zzhz2.zzal(n);
        float f2 = zzhz2.zzxn[n];
        zzhz2.zzxn[n] = f;
        return Float.valueOf(f2);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhz zzhz2 = this;
        zzhz2.zzek();
        zzhz2.zzal(n);
        float f = zzhz2.zzxn[n];
        if (n < zzhz2.size - 1) {
            System.arraycopy(zzhz2.zzxn, n + 1, zzhz2.zzxn, n, zzhz2.size - n - 1);
        }
        --zzhz2.size;
        ++zzhz2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        float f = ((Float)object).floatValue();
        zzhz zzhz2 = this;
        zzhz2.zzek();
        if (n < 0 || n > zzhz2.size) {
            throw new IndexOutOfBoundsException(zzhz2.zzam(n));
        }
        if (zzhz2.size < zzhz2.zzxn.length) {
            System.arraycopy(zzhz2.zzxn, n, zzhz2.zzxn, n + 1, zzhz2.size - n);
        } else {
            float[] fArray = new float[zzhz2.size * 3 / 2 + 1];
            System.arraycopy(zzhz2.zzxn, 0, fArray, 0, n);
            System.arraycopy(zzhz2.zzxn, n, fArray, n + 1, zzhz2.size - n);
            zzhz2.zzxn = fArray;
        }
        zzhz2.zzxn[n] = f;
        ++zzhz2.size;
        ++zzhz2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzu(((Float)object).floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzhz zzhz2 = this;
        if (n2 < zzhz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhz(Arrays.copyOf(zzhz2.zzxn, n2), zzhz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzhz zzhz2 = this;
        zzhz2.zzal(n);
        return Float.valueOf(zzhz2.zzxn[n]);
    }

    static {
        zzxm.zzej();
    }
}

