/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.Image;
import androidx.annotation.RequiresApi;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private final Metadata zzao = new Metadata();
    @Nullable
    private ByteBuffer zzap = null;
    @Nullable
    @RequiresApi(value=19)
    private zza zzaq = null;
    @Nullable
    private Bitmap zzar = null;

    public Metadata getMetadata() {
        return this.zzao;
    }

    @Nullable
    @KeepForSdk
    @RequiresApi(value=19)
    public Image.Plane[] getPlanes() {
        if (this.zzaq == null) {
            return null;
        }
        return this.zzaq.getPlanes();
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.zzar != null) {
            Frame frame = this;
            int n = frame.zzar.getWidth();
            int n2 = frame.zzar.getHeight();
            int[] nArray = new int[n * n2];
            frame.zzar.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzap;
    }

    public Bitmap getBitmap() {
        return this.zzar;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    static final class zza {
        private final Image.Plane[] zzay;

        zza(Image.Plane[] planeArray) {
            this.zzay = planeArray;
        }

        final Image.Plane[] getPlanes() {
            return this.zzay;
        }
    }

    public static class Metadata {
        private int width;
        private int height;
        private int id;
        private long zzaz;
        private int rotation;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.width = metadata.getWidth();
            this.height = metadata.getHeight();
            this.id = metadata.getId();
            this.zzaz = metadata.getTimestampMillis();
            this.rotation = metadata.getRotation();
            this.format = metadata.getFormat();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getId() {
            return this.id;
        }

        public long getTimestampMillis() {
            return this.zzaz;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getFormat() {
            return this.format;
        }

        public final void zzf() {
            if (this.rotation % 2 != 0) {
                int n = this.width;
                this.width = this.height;
                this.height = n;
            }
            this.rotation = 0;
        }
    }

    public static class Builder {
        private final Frame zzax = new Frame(null);

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzax.zzar = bitmap;
            Metadata metadata = this.zzax.getMetadata();
            metadata.width = n;
            metadata.height = n2;
            return this;
        }

        @KeepForSdk
        @RequiresApi(value=19)
        public Builder setPlanes(Image.Plane[] planeArray, int n, int n2, int n3) {
            if (planeArray == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (planeArray.length != 3) {
                throw new IllegalArgumentException("Only android.graphics.ImageFormat#YUV_420_888 is supported which should have 3 planes.");
            }
            if (planeArray[0].getBuffer().capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            this.zzax.zzaq = new zza(planeArray);
            Metadata metadata = this.zzax.getMetadata();
            metadata.width = n;
            metadata.height = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzax.zzap = byteBuffer;
            Metadata metadata = this.zzax.getMetadata();
            metadata.width = n;
            metadata.height = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzax.getMetadata().id = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzax.getMetadata().zzaz = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzax.getMetadata().rotation = n;
            return this;
        }

        public Frame build() {
            if (this.zzax.zzap == null && this.zzax.zzar == null && this.zzax.zzaq == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzax;
        }
    }
}

