/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzie;
import com.google.android.gms.internal.vision.zzik;
import com.google.android.gms.internal.vision.zzjz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzif
extends zzgi<Integer>
implements zzik<Integer>,
zzjz,
RandomAccess {
    private static final zzif zzzb = new zzif(new int[0], 0);
    private int[] zzzc;
    private int size;

    public static zzif zzhg() {
        return zzzb;
    }

    zzif() {
        this(new int[10], 0);
    }

    private zzif(int[] nArray, int n) {
        this.zzzc = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzek();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzzc, n2, this.zzzc, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzif)) {
            return super.equals(object);
        }
        zzif zzif2 = (zzif)object;
        if (this.size != zzif2.size) {
            return false;
        }
        int[] nArray = zzif2.zzzc;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzzc[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzzc[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzal(n);
        return this.zzzc[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzzc[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbs(int n) {
        this.zzek();
        if (this.size == this.zzzc.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzzc, 0, nArray, 0, this.size);
            this.zzzc = nArray;
        }
        this.zzzc[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzek();
        zzie.checkNotNull(collection);
        if (!(collection instanceof zzif)) {
            return super.addAll(collection);
        }
        zzif zzif2 = (zzif)collection;
        if (zzif2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzif2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzif2.size;
        if (n > this.zzzc.length) {
            this.zzzc = Arrays.copyOf(this.zzzc, n);
        }
        System.arraycopy(zzif2.zzzc, 0, this.zzzc, this.size, zzif2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzek();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzzc[i])) continue;
            System.arraycopy(this.zzzc, i + 1, this.zzzc, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzal(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzam(n));
        }
    }

    private final String zzam(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        int n2 = (Integer)object;
        zzif zzif2 = this;
        zzif2.zzek();
        zzif2.zzal(n);
        int n3 = zzif2.zzzc[n];
        zzif2.zzzc[n] = n2;
        return n3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzif zzif2 = this;
        zzif2.zzek();
        zzif2.zzal(n);
        int n2 = zzif2.zzzc[n];
        if (n < zzif2.size - 1) {
            System.arraycopy(zzif2.zzzc, n + 1, zzif2.zzzc, n, zzif2.size - n - 1);
        }
        --zzif2.size;
        ++zzif2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        int n2 = (Integer)object;
        zzif zzif2 = this;
        zzif2.zzek();
        if (n < 0 || n > zzif2.size) {
            throw new IndexOutOfBoundsException(zzif2.zzam(n));
        }
        if (zzif2.size < zzif2.zzzc.length) {
            System.arraycopy(zzif2.zzzc, n, zzif2.zzzc, n + 1, zzif2.size - n);
        } else {
            int[] nArray = new int[zzif2.size * 3 / 2 + 1];
            System.arraycopy(zzif2.zzzc, 0, nArray, 0, n);
            System.arraycopy(zzif2.zzzc, n, nArray, n + 1, zzif2.size - n);
            zzif2.zzzc = nArray;
        }
        zzif2.zzzc[n] = n2;
        ++zzif2.size;
        ++zzif2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzbs((Integer)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzik zzan(int n) {
        int n2 = n;
        zzif zzif2 = this;
        if (n2 < zzif2.size) {
            throw new IllegalArgumentException();
        }
        return new zzif(Arrays.copyOf(zzif2.zzzc, n2), zzif2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzzb.zzej();
    }
}

