/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfc;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzit;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgt
extends zzfc<Float>
implements zzhe<Float>,
zzit,
RandomAccess {
    private static final zzgt zzwf = new zzgt(new float[0], 0);
    private float[] zzwg;
    private int size;

    zzgt() {
        this(new float[10], 0);
    }

    private zzgt(float[] fArray, int n) {
        this.zzwg = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdr();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzwg, n2, this.zzwg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgt)) {
            return super.equals(object);
        }
        zzgt zzgt2 = (zzgt)object;
        if (this.size != zzgt2.size) {
            return false;
        }
        float[] fArray = zzgt2.zzwg;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzwg[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzwg[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Float)) {
            return -1;
        }
        float f = ((Float)object).floatValue();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzwg[i] != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzu(float f) {
        this.zzdr();
        if (this.size == this.zzwg.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzwg, 0, fArray, 0, this.size);
            this.zzwg = fArray;
        }
        this.zzwg[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzdr();
        zzgy.checkNotNull(collection);
        if (!(collection instanceof zzgt)) {
            return super.addAll(collection);
        }
        zzgt zzgt2 = (zzgt)collection;
        if (zzgt2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgt2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgt2.size;
        if (n > this.zzwg.length) {
            this.zzwg = Arrays.copyOf(this.zzwg, n);
        }
        System.arraycopy(zzgt2.zzwg, 0, this.zzwg, this.size, zzgt2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdr();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzwg[i]))) continue;
            System.arraycopy(this.zzwg, i + 1, this.zzwg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzgt zzgt2 = this;
        zzgt2.zzdr();
        zzgt2.zzaf(n);
        float f3 = zzgt2.zzwg[n];
        zzgt2.zzwg[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgt zzgt2 = this;
        zzgt2.zzdr();
        zzgt2.zzaf(n);
        float f = zzgt2.zzwg[n];
        if (n < zzgt2.size - 1) {
            System.arraycopy(zzgt2.zzwg, n + 1, zzgt2.zzwg, n, zzgt2.size - n - 1);
        }
        --zzgt2.size;
        ++zzgt2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzgt zzgt2 = this;
        zzgt2.zzdr();
        if (n < 0 || n > zzgt2.size) {
            throw new IndexOutOfBoundsException(zzgt2.zzag(n));
        }
        if (zzgt2.size < zzgt2.zzwg.length) {
            System.arraycopy(zzgt2.zzwg, n, zzgt2.zzwg, n + 1, zzgt2.size - n);
        } else {
            float[] fArray = new float[zzgt2.size * 3 / 2 + 1];
            System.arraycopy(zzgt2.zzwg, 0, fArray, 0, n);
            System.arraycopy(zzgt2.zzwg, n, fArray, n + 1, zzgt2.size - n);
            zzgt2.zzwg = fArray;
        }
        zzgt2.zzwg[n] = f2;
        ++zzgt2.size;
        ++zzgt2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Float f = (Float)object;
        this.zzu(f.floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzhe zzah(int n) {
        int n2 = n;
        zzgt zzgt2 = this;
        if (n2 < zzgt2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgt(Arrays.copyOf(zzgt2.zzwg, n2), zzgt2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgt zzgt2 = this;
        zzgt2.zzaf(n);
        return Float.valueOf(zzgt2.zzwg[n]);
    }

    static {
        zzwf.zzdq();
    }
}

