/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgo
extends zzex<Float>
implements zzgz<Float>,
zzio,
RandomAccess {
    private static final zzgo zzvq = new zzgo(new float[0], 0);
    private float[] zzvr;
    private int size;

    zzgo() {
        this(new float[10], 0);
    }

    private zzgo(float[] fArray, int n) {
        this.zzvr = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzvr, n2, this.zzvr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgo)) {
            return super.equals(object);
        }
        zzgo zzgo2 = (zzgo)object;
        if (this.size != zzgo2.size) {
            return false;
        }
        float[] fArray = zzgo2.zzvr;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzvr[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzvr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzu(float f) {
        this.zzdq();
        if (this.size == this.zzvr.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzvr, 0, fArray, 0, this.size);
            this.zzvr = fArray;
        }
        this.zzvr[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzgo)) {
            return super.addAll(collection);
        }
        zzgo zzgo2 = (zzgo)collection;
        if (zzgo2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgo2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgo2.size;
        if (n > this.zzvr.length) {
            this.zzvr = Arrays.copyOf(this.zzvr, n);
        }
        System.arraycopy(zzgo2.zzvr, 0, this.zzvr, this.size, zzgo2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzvr[i]))) continue;
            System.arraycopy(this.zzvr, i + 1, this.zzvr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzae(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaf(n));
        }
    }

    private final String zzaf(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzgo zzgo2 = this;
        zzgo2.zzdq();
        zzgo2.zzae(n);
        float f3 = zzgo2.zzvr[n];
        zzgo2.zzvr[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgo zzgo2 = this;
        zzgo2.zzdq();
        zzgo2.zzae(n);
        float f = zzgo2.zzvr[n];
        if (n < zzgo2.size - 1) {
            System.arraycopy(zzgo2.zzvr, n + 1, zzgo2.zzvr, n, zzgo2.size - n - 1);
        }
        --zzgo2.size;
        ++zzgo2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzgo zzgo2 = this;
        zzgo2.zzdq();
        if (n < 0 || n > zzgo2.size) {
            throw new IndexOutOfBoundsException(zzgo2.zzaf(n));
        }
        if (zzgo2.size < zzgo2.zzvr.length) {
            System.arraycopy(zzgo2.zzvr, n, zzgo2.zzvr, n + 1, zzgo2.size - n);
        } else {
            float[] fArray = new float[zzgo2.size * 3 / 2 + 1];
            System.arraycopy(zzgo2.zzvr, 0, fArray, 0, n);
            System.arraycopy(zzgo2.zzvr, n, fArray, n + 1, zzgo2.size - n);
            zzgo2.zzvr = fArray;
        }
        zzgo2.zzvr[n] = f2;
        ++zzgo2.size;
        ++zzgo2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Float f = (Float)object;
        this.zzu(f.floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzag(int n) {
        int n2 = n;
        zzgo zzgo2 = this;
        if (n2 < zzgo2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgo(Arrays.copyOf(zzgo2.zzvr, n2), zzgo2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgo zzgo2 = this;
        zzgo2.zzae(n);
        return Float.valueOf(zzgo2.zzvr[n]);
    }

    static {
        zzvq.zzdp();
    }
}

