/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgb
extends zzex<Double>
implements zzgz<Double>,
zzio,
RandomAccess {
    private static final zzgb zzst = new zzgb(new double[0], 0);
    private double[] zzsu;
    private int size;

    zzgb() {
        this(new double[10], 0);
    }

    private zzgb(double[] dArray, int n) {
        this.zzsu = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsu, n2, this.zzsu, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgb)) {
            return super.equals(object);
        }
        zzgb zzgb2 = (zzgb)object;
        if (this.size != zzgb2.size) {
            return false;
        }
        double[] dArray = zzgb2.zzsu;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzsu[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzsu[i]);
            n = n * 31 + zzgt.zzab(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzdq();
        if (this.size == this.zzsu.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsu, 0, dArray, 0, this.size);
            this.zzsu = dArray;
        }
        this.zzsu[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzgb)) {
            return super.addAll(collection);
        }
        zzgb zzgb2 = (zzgb)collection;
        if (zzgb2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgb2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgb2.size;
        if (n > this.zzsu.length) {
            this.zzsu = Arrays.copyOf(this.zzsu, n);
        }
        System.arraycopy(zzgb2.zzsu, 0, this.zzsu, this.size, zzgb2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsu[i])) continue;
            System.arraycopy(this.zzsu, i + 1, this.zzsu, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzae(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaf(n));
        }
    }

    private final String zzaf(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        zzgb2.zzae(n);
        double d3 = zzgb2.zzsu[n];
        zzgb2.zzsu[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        zzgb2.zzae(n);
        double d = zzgb2.zzsu[n];
        if (n < zzgb2.size - 1) {
            System.arraycopy(zzgb2.zzsu, n + 1, zzgb2.zzsu, n, zzgb2.size - n - 1);
        }
        --zzgb2.size;
        ++zzgb2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        if (n < 0 || n > zzgb2.size) {
            throw new IndexOutOfBoundsException(zzgb2.zzaf(n));
        }
        if (zzgb2.size < zzgb2.zzsu.length) {
            System.arraycopy(zzgb2.zzsu, n, zzgb2.zzsu, n + 1, zzgb2.size - n);
        } else {
            double[] dArray = new double[zzgb2.size * 3 / 2 + 1];
            System.arraycopy(zzgb2.zzsu, 0, dArray, 0, n);
            System.arraycopy(zzgb2.zzsu, n, dArray, n + 1, zzgb2.size - n);
            zzgb2.zzsu = dArray;
        }
        zzgb2.zzsu[n] = d2;
        ++zzgb2.size;
        ++zzgb2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzc(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzag(int n) {
        int n2 = n;
        zzgb zzgb2 = this;
        if (n2 < zzgb2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgb(Arrays.copyOf(zzgb2.zzsu, n2), zzgb2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgb zzgb2 = this;
        zzgb2.zzae(n);
        return zzgb2.zzsu[n];
    }

    static {
        zzst.zzdp();
    }
}

