/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzge;
import com.google.android.gms.internal.vision.zzhr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfz
extends zzef<Integer>
implements zzge<Integer>,
zzhr,
RandomAccess {
    private static final zzfz zzxl = new zzfz();
    private int[] zzxm;
    private int size;

    zzfz() {
        this(new int[10], 0);
    }

    private zzfz(int[] nArray, int n) {
        this.zzxm = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzxm, n2, this.zzxm, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfz)) {
            return super.equals(object);
        }
        zzfz zzfz2 = (zzfz)object;
        if (this.size != zzfz2.size) {
            return false;
        }
        int[] nArray = zzfz2.zzxm;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzxm[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzxm[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzaf(n);
        return this.zzxm[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbg(int n) {
        this.zzq(this.size, n);
    }

    private final void zzq(int n, int n2) {
        this.zzcj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
        if (this.size < this.zzxm.length) {
            System.arraycopy(this.zzxm, n, this.zzxm, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzxm, 0, nArray, 0, n);
            System.arraycopy(this.zzxm, n, nArray, n + 1, this.size - n);
            this.zzxm = nArray;
        }
        this.zzxm[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcj();
        zzga.checkNotNull(collection);
        if (!(collection instanceof zzfz)) {
            return super.addAll(collection);
        }
        zzfz zzfz2 = (zzfz)collection;
        if (zzfz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfz2.size;
        if (n > this.zzxm.length) {
            this.zzxm = Arrays.copyOf(this.zzxm, n);
        }
        System.arraycopy(zzfz2.zzxm, 0, this.zzxm, this.size, zzfz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzxm[i])) continue;
            System.arraycopy(this.zzxm, i + 1, this.zzxm, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfz zzfz2 = this;
        zzfz2.zzcj();
        zzfz2.zzaf(n);
        int n4 = zzfz2.zzxm[n];
        zzfz2.zzxm[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfz zzfz2 = this;
        zzfz2.zzcj();
        zzfz2.zzaf(n);
        int n2 = zzfz2.zzxm[n];
        if (n < zzfz2.size - 1) {
            System.arraycopy(zzfz2.zzxm, n + 1, zzfz2.zzxm, n, zzfz2.size - n);
        }
        --zzfz2.size;
        ++zzfz2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzq(n, n2);
    }

    @Override
    public final /* synthetic */ zzge zzah(int n) {
        int n2 = n;
        zzfz zzfz2 = this;
        if (n2 < zzfz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfz(Arrays.copyOf(zzfz2.zzxm, n2), zzfz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzxl.zzci();
    }
}

