/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzej;
import com.google.android.gms.internal.vision.zzem;
import com.google.android.gms.internal.vision.zzeo;
import com.google.android.gms.internal.vision.zzez;
import com.google.android.gms.internal.vision.zzfh;
import com.google.android.gms.internal.vision.zzfk;
import com.google.android.gms.internal.vision.zzfv;
import com.google.android.gms.internal.vision.zzfz;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzgf;
import com.google.android.gms.internal.vision.zzgg;
import com.google.android.gms.internal.vision.zzgo;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhs;
import com.google.android.gms.internal.vision.zzhw;
import com.google.android.gms.internal.vision.zziw;
import com.google.android.gms.internal.vision.zzjd;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

final class zzel
extends zzej {
    private final boolean zzrs;
    private final byte[] buffer;
    private int pos;
    private final int zzrt;
    private int limit;
    private int tag;
    private int zzru;

    public zzel(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.zzrs = true;
        this.buffer = byteBuffer.array();
        this.zzrt = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
        this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
    }

    private final boolean zzcm() {
        return this.pos == this.limit;
    }

    @Override
    public final int zzcn() throws IOException {
        if (this.zzcm()) {
            return Integer.MAX_VALUE;
        }
        this.tag = this.zzdd();
        if (this.tag == this.zzru) {
            return Integer.MAX_VALUE;
        }
        return this.tag >>> 3;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzco() throws IOException {
        if (this.zzcm() || this.tag == this.zzru) {
            return false;
        }
        switch (this.tag & 7) {
            case 0: {
                zzel zzel2 = this;
                if (zzel2.limit - zzel2.pos >= 10) {
                    byte[] byArray = zzel2.buffer;
                    int n = zzel2.pos;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray[n++] < 0) continue;
                        zzel2.pos = n;
                        return true;
                    }
                } else {
                    zzel zzel3 = zzel2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzel3.readByte() >= 0) return true;
                    }
                    throw zzgf.zzfj();
                }
            }
            case 1: {
                this.zzz(8);
                return true;
            }
            case 2: {
                this.zzz(this.zzdd());
                return true;
            }
            case 5: {
                this.zzz(4);
                return true;
            }
            case 3: {
                zzel zzel4 = this;
                int n = zzel4.zzru;
                zzel4.zzru = zzel4.tag >>> 3 << 3 | 4;
                while (zzel4.zzcn() != Integer.MAX_VALUE && zzel4.zzco()) {
                }
                if (zzel4.tag != zzel4.zzru) {
                    throw zzgf.zzfo();
                }
                zzel4.zzru = n;
                return true;
            }
        }
        throw zzgf.zzfm();
    }

    @Override
    public final double readDouble() throws IOException {
        this.zzab(1);
        return Double.longBitsToDouble(this.zzdh());
    }

    @Override
    public final float readFloat() throws IOException {
        this.zzab(5);
        return Float.intBitsToFloat(this.zzdg());
    }

    @Override
    public final long zzcp() throws IOException {
        this.zzab(0);
        return this.zzde();
    }

    @Override
    public final long zzcq() throws IOException {
        this.zzab(0);
        return this.zzde();
    }

    @Override
    public final int zzcr() throws IOException {
        this.zzab(0);
        return this.zzdd();
    }

    @Override
    public final long zzcs() throws IOException {
        this.zzab(1);
        return this.zzdh();
    }

    @Override
    public final int zzct() throws IOException {
        this.zzab(5);
        return this.zzdg();
    }

    @Override
    public final boolean zzcu() throws IOException {
        this.zzab(0);
        return this.zzdd() != 0;
    }

    @Override
    public final String readString() throws IOException {
        return this.zzg(false);
    }

    @Override
    public final String zzcv() throws IOException {
        return this.zzg(true);
    }

    private final String zzg(boolean bl) throws IOException {
        this.zzab(2);
        int n = this.zzdd();
        if (n == 0) {
            return "";
        }
        this.zzaa(n);
        if (bl && !zziw.zzg(this.buffer, this.pos, this.pos + n)) {
            throw zzgf.zzfp();
        }
        String string = new String(this.buffer, this.pos, n, zzga.UTF_8);
        this.pos += n;
        return string;
    }

    @Override
    public final <T> T zza(Class<T> clazz, zzfk zzfk2) throws IOException {
        this.zzab(2);
        return this.zzb(zzhs.zzgl().zzf(clazz), zzfk2);
    }

    @Override
    public final <T> T zza(zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        this.zzab(2);
        return this.zzb(zzhw2, zzfk2);
    }

    private final <T> T zzb(zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        int n;
        int n2 = this.zzdd();
        this.zzaa(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            T t = zzhw2.newInstance();
            zzhw2.zza(t, this, zzfk2);
            zzhw2.zze(t);
            if (this.pos != n) {
                throw zzgf.zzfo();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.limit = n3;
        }
    }

    @Override
    public final <T> T zzb(Class<T> clazz, zzfk zzfk2) throws IOException {
        this.zzab(3);
        return this.zzd(zzhs.zzgl().zzf(clazz), zzfk2);
    }

    @Override
    public final <T> T zzc(zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        this.zzab(3);
        return this.zzd(zzhw2, zzfk2);
    }

    private final <T> T zzd(zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        int n = this.zzru;
        this.zzru = this.tag >>> 3 << 3 | 4;
        try {
            T t = zzhw2.newInstance();
            zzhw2.zza(t, this, zzfk2);
            zzhw2.zze(t);
            if (this.tag != this.zzru) {
                throw zzgf.zzfo();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zzru = n;
        }
    }

    @Override
    public final zzeo zzcw() throws IOException {
        this.zzab(2);
        int n = this.zzdd();
        if (n == 0) {
            return zzeo.zzrx;
        }
        this.zzaa(n);
        zzeo zzeo2 = this.zzrs ? zzeo.zzc(this.buffer, this.pos, n) : zzeo.zzb(this.buffer, this.pos, n);
        this.pos += n;
        return zzeo2;
    }

    @Override
    public final int zzcx() throws IOException {
        this.zzab(0);
        return this.zzdd();
    }

    @Override
    public final int zzcy() throws IOException {
        this.zzab(0);
        return this.zzdd();
    }

    @Override
    public final int zzcz() throws IOException {
        this.zzab(5);
        return this.zzdg();
    }

    @Override
    public final long zzda() throws IOException {
        this.zzab(1);
        return this.zzdh();
    }

    @Override
    public final int zzdb() throws IOException {
        this.zzab(0);
        return zzez.zzaq(this.zzdd());
    }

    @Override
    public final long zzdc() throws IOException {
        this.zzab(0);
        return zzez.zzd(this.zzde());
    }

    @Override
    public final void zza(List<Double> list) throws IOException {
        if (list instanceof zzfh) {
            zzfh zzfh2 = (zzfh)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzac(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfh2.zzc(Double.longBitsToDouble(this.zzdj()));
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzfh2.zzc(this.readDouble());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzac(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Double.longBitsToDouble(this.zzdj()));
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.readDouble());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzb(List<Float> list) throws IOException {
        if (list instanceof zzfv) {
            zzfv zzfv2 = (zzfv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzad(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfv2.zzh(Float.intBitsToFloat(this.zzdi()));
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzfv2.zzh(this.readFloat());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzad(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Float.valueOf(Float.intBitsToFloat(this.zzdi())));
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzc(List<Long> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzp(this.zzde());
                    }
                    this.zzae(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzgt2.zzp(this.zzcp());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzgf.zzfm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzde());
                }
                this.zzae(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcp());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzgf.zzfm();
    }

    @Override
    public final void zzd(List<Long> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzp(this.zzde());
                    }
                    this.zzae(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzgt2.zzp(this.zzcq());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzgf.zzfm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzde());
                }
                this.zzae(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcq());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzgf.zzfm();
    }

    @Override
    public final void zze(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(this.zzdd());
                    }
                    this.zzae(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzcr());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzgf.zzfm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdd());
                }
                this.zzae(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcr());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzgf.zzfm();
    }

    @Override
    public final void zzf(List<Long> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzac(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzp(this.zzdj());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzgt2.zzp(this.zzcs());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzac(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdj());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzcs());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzg(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzad(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(this.zzdi());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzct());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzad(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdi());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzct());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzh(List<Boolean> list) throws IOException {
        if (list instanceof zzem) {
            zzem zzem2 = (zzem)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzem2.addBoolean(this.zzdd() != 0);
                    }
                    this.zzae(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzem2.addBoolean(this.zzcu());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzgf.zzfm();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdd() != 0);
                }
                this.zzae(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcu());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzgf.zzfm();
    }

    @Override
    public final void readStringList(List<String> list) throws IOException {
        this.zza(list, false);
    }

    @Override
    public final void zzi(List<String> list) throws IOException {
        this.zza(list, true);
    }

    private final void zza(List<String> list, boolean bl) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzgf.zzfm();
        }
        if (list instanceof zzgo && !bl) {
            int n2;
            zzgo zzgo2 = (zzgo)list;
            do {
                zzgo2.zzc(this.zzcw());
                if (this.zzcm()) {
                    return;
                }
                n2 = this.pos;
            } while (this.zzdd() == this.tag);
            this.pos = n2;
            return;
        }
        do {
            list.add(this.zzg(bl));
            if (this.zzcm()) {
                return;
            }
            n = this.pos;
        } while (this.zzdd() == this.tag);
        this.pos = n;
    }

    @Override
    public final <T> void zza(List<T> list, zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzgf.zzfm();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzb(zzhw2, zzfk2));
            if (this.zzcm()) {
                return;
            }
            n = this.pos;
        } while (this.zzdd() == n2);
        this.pos = n;
    }

    @Override
    public final <T> void zzb(List<T> list, zzhw<T> zzhw2, zzfk zzfk2) throws IOException {
        int n;
        if ((this.tag & 7) != 3) {
            throw zzgf.zzfm();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzd(zzhw2, zzfk2));
            if (this.zzcm()) {
                return;
            }
            n = this.pos;
        } while (this.zzdd() == n2);
        this.pos = n;
    }

    @Override
    public final void zzj(List<zzeo> list) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzgf.zzfm();
        }
        do {
            list.add(this.zzcw());
            if (this.zzcm()) {
                return;
            }
            n = this.pos;
        } while (this.zzdd() == this.tag);
        this.pos = n;
    }

    @Override
    public final void zzk(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(this.zzdd());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzcx());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdd());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcx());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzl(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(this.zzdd());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzcy());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdd());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzcy());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzm(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzad(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(this.zzdi());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzcz());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzad(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdi());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzcz());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzn(List<Long> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    this.zzac(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzp(this.zzdj());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzgt2.zzp(this.zzda());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                this.zzac(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzdj());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzda());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzo(List<Integer> list) throws IOException {
        if (list instanceof zzfz) {
            zzfz zzfz2 = (zzfz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfz2.zzbg(zzez.zzaq(this.zzdd()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzfz2.zzbg(this.zzdb());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzez.zzaq(this.zzdd()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdb());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final void zzp(List<Long> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzdd();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzp(zzez.zzd(this.zzde()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgt2.zzp(this.zzdc());
                        if (this.zzcm()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzdd() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzgf.zzfm();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzdd();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzez.zzd(this.zzde()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdc());
                    if (this.zzcm()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzdd() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzgf.zzfm();
            }
        }
    }

    @Override
    public final <K, V> void zza(Map<K, V> map, zzgy<K, V> zzgy2, zzfk zzfk2) throws IOException {
        int n;
        this.zzab(2);
        int n2 = this.zzdd();
        this.zzaa(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            int n4;
            Object object = zzgy2.zzyw;
            Object object2 = zzgy2.zzgq;
            block9: while ((n4 = this.zzcn()) != Integer.MAX_VALUE) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.zza(zzgy2.zzyv, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.zza(zzgy2.zzyx, zzgy2.zzgq.getClass(), zzfk2);
                            continue block9;
                        }
                    }
                    if (this.zzco()) continue;
                    throw new zzgf("Unable to parse map entry.");
                }
                catch (zzgg zzgg2) {
                    if (this.zzco()) continue;
                    throw new zzgf("Unable to parse map entry.");
                }
            }
            map.put(object, object2);
            return;
        }
        finally {
            this.limit = n3;
        }
    }

    private final Object zza(zzjd zzjd2, Class<?> clazz, zzfk zzfk2) throws IOException {
        switch (zzjd2) {
            case zzacb: {
                return this.zzcu();
            }
            case zzacf: {
                return this.zzcw();
            }
            case zzabu: {
                return this.readDouble();
            }
            case zzach: {
                return this.zzcy();
            }
            case zzaca: {
                return this.zzct();
            }
            case zzabz: {
                return this.zzcs();
            }
            case zzabv: {
                return Float.valueOf(this.readFloat());
            }
            case zzaby: {
                return this.zzcr();
            }
            case zzabw: {
                return this.zzcq();
            }
            case zzace: {
                return this.zza(clazz, zzfk2);
            }
            case zzaci: {
                return this.zzcz();
            }
            case zzacj: {
                return this.zzda();
            }
            case zzack: {
                return this.zzdb();
            }
            case zzacl: {
                return this.zzdc();
            }
            case zzacc: {
                return this.zzg(true);
            }
            case zzacg: {
                return this.zzcx();
            }
            case zzabx: {
                return this.zzcp();
            }
        }
        throw new RuntimeException("unsupported field type.");
    }

    private final int zzdd() throws IOException {
        int n;
        int n2 = this.pos;
        if (this.limit == this.pos) {
            throw zzgf.zzfh();
        }
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return (int)this.zzdf();
        }
        if ((n ^= this.buffer[n2++] << 7) < 0) {
            n ^= 0xFFFFFF80;
        } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
            n ^= 0x3F80;
        } else if ((n ^= this.buffer[n2++] << 21) < 0) {
            n ^= 0xFFE03F80;
        } else {
            byte by = this.buffer[n2++];
            n = n ^ by << 28 ^ 0xFE03F80;
            if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                throw zzgf.zzfj();
            }
        }
        this.pos = n2;
        return n;
    }

    private final long zzde() throws IOException {
        long l;
        int n;
        int n2 = this.pos;
        if (this.limit == n2) {
            throw zzgf.zzfh();
        }
        byte[] byArray = this.buffer;
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return this.zzdf();
        }
        if ((n ^= byArray[n2++] << 7) < 0) {
            l = n ^ 0xFFFFFF80;
        } else if ((n ^= byArray[n2++] << 14) >= 0) {
            l = n ^ 0x3F80;
        } else if ((n ^= byArray[n2++] << 21) < 0) {
            l = n ^ 0xFFE03F80;
        } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
            l ^= 0xFE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
            l ^= 0xFFFFFFF80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
            l ^= 0x3F80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
            l ^= 0xFFFE03F80FE03F80L;
        } else if ((l = l ^ (long)byArray[n2++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
            throw zzgf.zzfj();
        }
        this.pos = n2;
        return l;
    }

    private final long zzdf() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzgf.zzfj();
    }

    private final byte readByte() throws IOException {
        if (this.pos == this.limit) {
            throw zzgf.zzfh();
        }
        return this.buffer[this.pos++];
    }

    private final int zzdg() throws IOException {
        this.zzaa(4);
        return this.zzdi();
    }

    private final long zzdh() throws IOException {
        this.zzaa(8);
        return this.zzdj();
    }

    private final int zzdi() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzdj() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private final void zzz(int n) throws IOException {
        this.zzaa(n);
        this.pos += n;
    }

    private final void zzaa(int n) throws IOException {
        if (n < 0 || n > this.limit - this.pos) {
            throw zzgf.zzfh();
        }
    }

    private final void zzab(int n) throws IOException {
        if ((this.tag & 7) != n) {
            throw zzgf.zzfm();
        }
    }

    private final void zzac(int n) throws IOException {
        this.zzaa(n);
        if ((n & 7) != 0) {
            throw zzgf.zzfo();
        }
    }

    private final void zzad(int n) throws IOException {
        this.zzaa(n);
        if ((n & 3) != 0) {
            throw zzgf.zzfo();
        }
    }

    private final void zzae(int n) throws IOException {
        if (this.pos != n) {
            throw zzgf.zzfh();
        }
    }
}

