/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzbi;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzcw;
import com.google.android.gms.internal.vision.zzej;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcs
extends zzbi<Integer>
implements zzcw<Integer>,
zzej,
RandomAccess {
    private static final zzcs zzlm = new zzcs();
    private int[] zzln;
    private int size;

    zzcs() {
        this(new int[10], 0);
    }

    private zzcs(int[] nArray, int n) {
        this.zzln = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzap();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzln, n2, this.zzln, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcs)) {
            return super.equals(object);
        }
        zzcs zzcs2 = (zzcs)object;
        if (this.size != zzcs2.size) {
            return false;
        }
        int[] nArray = zzcs2.zzln;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzln[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzln[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzi(n);
        return this.zzln[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzae(int n) {
        this.zzq(this.size, n);
    }

    private final void zzq(int n, int n2) {
        this.zzap();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
        if (this.size < this.zzln.length) {
            System.arraycopy(this.zzln, n, this.zzln, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzln, 0, nArray, 0, n);
            System.arraycopy(this.zzln, n, nArray, n + 1, this.size - n);
            this.zzln = nArray;
        }
        this.zzln[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzap();
        zzct.checkNotNull(collection);
        if (!(collection instanceof zzcs)) {
            return super.addAll(collection);
        }
        zzcs zzcs2 = (zzcs)collection;
        if (zzcs2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcs2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcs2.size;
        if (n > this.zzln.length) {
            this.zzln = Arrays.copyOf(this.zzln, n);
        }
        System.arraycopy(zzcs2.zzln, 0, this.zzln, this.size, zzcs2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzap();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzln[i])) continue;
            System.arraycopy(this.zzln, i + 1, this.zzln, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzi(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzj(n));
        }
    }

    private final String zzj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzcs zzcs2 = this;
        zzcs2.zzap();
        zzcs2.zzi(n);
        int n4 = zzcs2.zzln[n];
        zzcs2.zzln[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcs zzcs2 = this;
        zzcs2.zzap();
        zzcs2.zzi(n);
        int n2 = zzcs2.zzln[n];
        if (n < zzcs2.size - 1) {
            System.arraycopy(zzcs2.zzln, n + 1, zzcs2.zzln, n, zzcs2.size - n);
        }
        --zzcs2.size;
        ++zzcs2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzq(n, n2);
    }

    @Override
    public final /* synthetic */ zzcw zzk(int n) {
        int n2 = n;
        zzcs zzcs2 = this;
        if (n2 < zzcs2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcs(Arrays.copyOf(zzcs2.zzln, n2), zzcs2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzlm.zzao();
    }
}

