/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzlft = new Object();
    private Processor<T> zzlfu;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzlft;
        synchronized (object) {
            if (this.zzlfu != null) {
                this.zzlfu.release();
                this.zzlfu = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zzblk();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zzlft;
        synchronized (object) {
            if (detector.zzlfu == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzlfu.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zzlft;
        synchronized (object) {
            if (this.zzlfu != null) {
                this.zzlfu.release();
            }
            this.zzlfu = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zzlfv;
        private final Frame.Metadata zzlfw;
        private final boolean zzlfx;

        @Hide
        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzlfv = sparseArray;
            this.zzlfw = metadata;
            this.zzlfx = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzlfv;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzlfw;
        }

        public boolean detectorIsOperational() {
            return this.zzlfx;
        }
    }
}

