/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zza = new Object();
    private Processor<T> zzb;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb != null) {
                this.zzb.release();
                this.zzb = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zza();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zza;
        synchronized (object) {
            if (detector.zzb == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzb.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb != null) {
                this.zzb.release();
            }
            this.zzb = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zza;
        private final Frame.Metadata zzb;
        private final boolean zzc;

        @Hide
        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zza = sparseArray;
            this.zzb = metadata;
            this.zzc = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zza;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzb;
        }

        public boolean detectorIsOperational() {
            return this.zzc;
        }
    }
}

