/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzkhy = new Metadata();
    private ByteBuffer zzkhz = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzkhy;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            Frame frame = this;
            int n = frame.mBitmap.getWidth();
            int n2 = frame.mBitmap.getHeight();
            int[] nArray = new int[n * n2];
            frame.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzkhz;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    public static class Metadata {
        private int zzakq;
        private int zzakr;
        private int mId;
        private long zzhln;
        private int zzcew;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzakq = metadata.getWidth();
            this.zzakr = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzhln = metadata.getTimestampMillis();
            this.zzcew = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzakq;
        }

        public int getHeight() {
            return this.zzakr;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzhln;
        }

        public int getRotation() {
            return this.zzcew;
        }

        public int getFormat() {
            return this.format;
        }

        public final void zzbil() {
            if (this.zzcew % 2 != 0) {
                int n = this.zzakq;
                this.zzakq = this.zzakr;
                this.zzakr = n;
            }
            this.zzcew = 0;
        }
    }

    public static class Builder {
        private Frame zzkia = new Frame(null);

        public Builder() {
        }

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzkia.mBitmap = bitmap;
            Metadata metadata = this.zzkia.getMetadata();
            metadata.zzakq = n;
            metadata.zzakr = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzkia.zzkhz = byteBuffer;
            Metadata metadata = this.zzkia.getMetadata();
            metadata.zzakq = n;
            metadata.zzakr = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzkia.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzkia.getMetadata().zzhln = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzkia.getMetadata().zzcew = n;
            return this;
        }

        public Frame build() {
            if (this.zzkia.zzkhz == null && this.zzkia.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzkia;
        }
    }
}

