/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbMT = new Metadata();
    private ByteBuffer zzbMU = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbMT;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            Frame frame = this;
            int n = frame.mBitmap.getWidth();
            int n2 = frame.mBitmap.getHeight();
            int[] nArray = new int[n * n2];
            frame.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzbMU;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    public static class Metadata {
        private int zzrY;
        private int zzrZ;
        private int mId;
        private long zzbcV;
        private int zzOa;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzrY = metadata.getWidth();
            this.zzrZ = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzbcV = metadata.getTimestampMillis();
            this.zzOa = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzrY;
        }

        public int getHeight() {
            return this.zzrZ;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzbcV;
        }

        public int getRotation() {
            return this.zzOa;
        }

        public int getFormat() {
            return this.format;
        }

        public final void zzDM() {
            if (this.zzOa % 2 != 0) {
                int n = this.zzrY;
                this.zzrY = this.zzrZ;
                this.zzrZ = n;
            }
            this.zzOa = 0;
        }
    }

    public static class Builder {
        private Frame zzbMV = new Frame(null);

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zzbMV.mBitmap = bitmap;
            Metadata metadata = this.zzbMV.getMetadata();
            metadata.zzrY = n;
            metadata.zzrZ = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zzbMV.zzbMU = byteBuffer;
            Metadata metadata = this.zzbMV.getMetadata();
            metadata.zzrY = n;
            metadata.zzrZ = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.zzbMV.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.zzbMV.getMetadata().zzbcV = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.zzbMV.getMetadata().zzOa = n;
            return this;
        }

        public Frame build() {
            if (this.zzbMV.zzbMU == null && this.zzbMV.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbMV;
        }
    }
}

