/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzh;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzh<TResult> zzh2 = new zzh<TResult>();
        zzh2.setResult(TResult);
        return zzh2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzh zzh2 = new zzh();
        zzh2.setException(exception);
        return zzh2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, final @NonNull Callable<TResult> callable) {
        zzac.zzb((Object)executor, (Object)"Executor must not be null");
        zzac.zzb(callable, (Object)"Callback must not be null");
        final zzh zzh2 = new zzh();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    zzh2.setResult(callable.call());
                }
                catch (Exception exception) {
                    zzh2.setException(exception);
                }
            }
        });
        return zzh2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzac.zzavb();
        zzac.zzb(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzb(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzac.zzavb();
        zzac.zzb(task, (Object)"Task must not be null");
        zzac.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzb(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        Task<?> task2;
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        for (Task<?> task2 : collection) {
            if (task2 != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        zzh zzh2 = new zzh();
        task2 = new zzc(collection.size(), zzh2);
        for (Task<?> task3 : collection) {
            Tasks.zza(task3, (zzb)((Object)task2));
        }
        return zzh2;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzb(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.aJI, zzb2);
        task.addOnFailureListener(TaskExecutors.aJI, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    private static final class zzc
    implements zzb {
        private final Object zzakd = new Object();
        private final int aJO;
        private final zzh<Void> aJH;
        private int aJP;
        private int aJQ;
        private Exception aJM;

        public zzc(int n, zzh<Void> zzh2) {
            this.aJO = n;
            this.aJH = zzh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Exception exception) {
            Object object = this.zzakd;
            synchronized (object) {
                ++this.aJQ;
                this.aJM = exception;
                this.zzclk();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(Object object) {
            Object object2 = this.zzakd;
            synchronized (object2) {
                ++this.aJP;
                this.zzclk();
            }
        }

        private void zzclk() {
            if (this.aJP + this.aJQ == this.aJO) {
                if (this.aJM == null) {
                    this.aJH.setResult(null);
                } else {
                    int n = this.aJQ;
                    int n2 = this.aJO;
                    this.aJH.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.aJM));
                }
            }
        }
    }

    private static final class zza
    implements zzb {
        private final CountDownLatch zzamx = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public void onSuccess(Object object) {
            this.zzamx.countDown();
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            this.zzamx.countDown();
        }

        public void await() throws InterruptedException {
            this.zzamx.await();
        }

        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zzamx.await(l, timeUnit);
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

