/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzu;
import com.google.android.gms.tasks.zzv;
import com.google.android.gms.tasks.zzw;
import com.google.android.gms.tasks.zzx;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        zzu2.setResult(TResult);
        return zzu2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzu zzu2 = new zzu();
        zzu2.setException(exception);
        return zzu2;
    }

    public static <TResult> Task<TResult> forCanceled() {
        zzu zzu2 = new zzu();
        zzu2.zzdp();
        return zzu2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull(callable, (Object)"Callback must not be null");
        zzu zzu2 = new zzu();
        executor.execute(new zzv(zzu2, callable));
        return zzu2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzb(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzb(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzu();
        zzc zzc2 = new zzc(collection.size(), (zzu<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWith(new zzw(collection));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArray) {
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    public static Task<List<Task<?>>> whenAllComplete(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWithTask(new zzx(collection));
    }

    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzb(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zzagd, zzb2);
        task.addOnFailureListener(TaskExecutors.zzagd, (OnFailureListener)zzb2);
        task.addOnCanceledListener(TaskExecutors.zzagd, (OnCanceledListener)zzb2);
    }

    private Tasks() {
    }

    private static final class zzc
    implements zzb {
        private final Object mLock = new Object();
        private final int zzagl;
        private final zzu<Void> zzafh;
        @GuardedBy(value="mLock")
        private int zzagm;
        @GuardedBy(value="mLock")
        private int zzagn;
        @GuardedBy(value="mLock")
        private int zzago;
        @GuardedBy(value="mLock")
        private Exception zzagh;
        @GuardedBy(value="mLock")
        private boolean zzagp;

        public zzc(int n, zzu<Void> zzu2) {
            this.zzagl = n;
            this.zzafh = zzu2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.zzagn;
                this.zzagh = exception;
                this.zzdu();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.mLock;
            synchronized (object2) {
                ++this.zzagm;
                this.zzdu();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onCanceled() {
            Object object = this.mLock;
            synchronized (object) {
                ++this.zzago;
                this.zzagp = true;
                this.zzdu();
                return;
            }
        }

        @GuardedBy(value="mLock")
        private final void zzdu() {
            if (this.zzagm + this.zzagn + this.zzago == this.zzagl) {
                if (this.zzagh != null) {
                    int n = this.zzagn;
                    int n2 = this.zzagl;
                    this.zzafh.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzagh));
                    return;
                }
                if (this.zzagp) {
                    this.zzafh.zzdp();
                    return;
                }
                this.zzafh.setResult(null);
            }
        }
    }

    private static final class zza
    implements zzb {
        private final CountDownLatch zzfd = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zzfd.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zzfd.countDown();
        }

        @Override
        public final void onCanceled() {
            this.zzfd.countDown();
        }

        public final void await() throws InterruptedException {
            this.zzfd.await();
        }

        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zzfd.await(l, timeUnit);
        }

        /* synthetic */ zza(zzv zzv2) {
            this();
        }
    }

    static interface zzb
    extends OnCanceledListener,
    OnFailureListener,
    OnSuccessListener<Object> {
    }
}

