/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.app.Activity;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzc;
import com.google.android.gms.tasks.zze;
import com.google.android.gms.tasks.zzg;
import com.google.android.gms.tasks.zzi;
import com.google.android.gms.tasks.zzk;
import com.google.android.gms.tasks.zzm;
import com.google.android.gms.tasks.zzo;
import com.google.android.gms.tasks.zzq;
import com.google.android.gms.tasks.zzr;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

final class zzu<TResult>
extends Task<TResult> {
    private final Object mLock = new Object();
    private final zzr<TResult> zzage = new zzr();
    @GuardedBy(value="mLock")
    private boolean zzagf;
    private volatile boolean zzfi;
    @GuardedBy(value="mLock")
    private TResult zzagg;
    @GuardedBy(value="mLock")
    private Exception zzagh;

    zzu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzagf;
        }
    }

    @Override
    public final boolean isCanceled() {
        return this.zzfi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSuccessful() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzagf && !this.zzfi && this.zzagh == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult getResult() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdq();
            this.zzds();
            if (this.zzagh != null) {
                throw new RuntimeExecutionException(this.zzagh);
            }
            return this.zzagg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdq();
            this.zzds();
            if (clazz.isInstance(this.zzagh)) {
                throw (Throwable)clazz.cast(this.zzagh);
            }
            if (this.zzagh != null) {
                throw new RuntimeExecutionException(this.zzagh);
            }
            return this.zzagg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final Exception getException() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzagh;
        }
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        return ((Task)this).addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        this.zzage.zza(new zzm<TResult>(executor, onSuccessListener));
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzm<? super TResult> zzm2 = new zzm<TResult>(TaskExecutors.MAIN_THREAD, onSuccessListener);
        this.zzage.zza(zzm2);
        zza.zze(activity).zzb(zzm2);
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return ((Task)this).addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        this.zzage.zza(new zzk(executor, onFailureListener));
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzk zzk2 = new zzk(TaskExecutors.MAIN_THREAD, onFailureListener);
        this.zzage.zza(zzk2);
        zza.zze(activity).zzb(zzk2);
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        return ((Task)this).addOnCompleteListener(TaskExecutors.MAIN_THREAD, onCompleteListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        this.zzage.zza(new zzi<TResult>(executor, onCompleteListener));
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzi<TResult> zzi2 = new zzi<TResult>(TaskExecutors.MAIN_THREAD, onCompleteListener);
        this.zzage.zza(zzi2);
        zza.zze(activity).zzb(zzi2);
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return ((Task)this).continueWith(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzage.zza(new zzc<TResult, TContinuationResult>(executor, continuation, zzu2));
        this.zzdt();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return ((Task)this).continueWithTask(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull OnCanceledListener onCanceledListener) {
        return ((Task)this).addOnCanceledListener(TaskExecutors.MAIN_THREAD, onCanceledListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener onCanceledListener) {
        this.zzage.zza(new zzg(executor, onCanceledListener));
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener onCanceledListener) {
        zzg zzg2 = new zzg(TaskExecutors.MAIN_THREAD, onCanceledListener);
        this.zzage.zza(zzg2);
        zza.zze(activity).zzb(zzg2);
        this.zzdt();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzage.zza(new zze<TResult, TContinuationResult>(executor, continuation, zzu2));
        this.zzdt();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(Executor executor, SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzage.zza(new zzo<TResult, TContinuationResult>(executor, successContinuation, zzu2));
        this.zzdt();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        return ((Task)this).onSuccessTask(TaskExecutors.MAIN_THREAD, successContinuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdr();
            this.zzagf = true;
            this.zzagg = TResult;
        }
        this.zzage.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzagf) {
                return false;
            }
            this.zzagf = true;
            this.zzagg = TResult;
        }
        this.zzage.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            this.zzdr();
            this.zzagf = true;
            this.zzagh = exception;
        }
        this.zzage.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetException(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzagf) {
                return false;
            }
            this.zzagf = true;
            this.zzagh = exception;
        }
        this.zzage.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdp() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzagf) {
                return false;
            }
            this.zzagf = true;
            this.zzfi = true;
        }
        this.zzage.zza(this);
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zzdq() {
        Preconditions.checkState((boolean)this.zzagf, (Object)"Task is not yet complete");
    }

    @GuardedBy(value="mLock")
    private final void zzdr() {
        Preconditions.checkState((!this.zzagf ? 1 : 0) != 0, (Object)"Task is already complete");
    }

    @GuardedBy(value="mLock")
    private final void zzds() {
        if (this.zzfi) {
            throw new CancellationException("Task is already canceled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzdt() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzagf) {
                return;
            }
        }
        this.zzage.zza(this);
    }

    private static class zza
    extends LifecycleCallback {
        private final List<WeakReference<zzq<?>>> zzagi = new ArrayList();

        public static zza zze(Activity activity) {
            LifecycleFragment lifecycleFragment = zza.getFragment((Activity)activity);
            zza zza2 = (zza)lifecycleFragment.getCallbackOrNull("TaskOnStopCallback", zza.class);
            if (zza2 == null) {
                zza2 = new zza(lifecycleFragment);
            }
            return zza2;
        }

        private zza(LifecycleFragment lifecycleFragment) {
            super(lifecycleFragment);
            this.mLifecycleFragment.addCallback("TaskOnStopCallback", (LifecycleCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> void zzb(zzq<T> zzq2) {
            List<WeakReference<zzq<?>>> list = this.zzagi;
            synchronized (list) {
                this.zzagi.add(new WeakReference<zzq<T>>(zzq2));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onStop() {
            List<WeakReference<zzq<?>>> list = this.zzagi;
            synchronized (list) {
                Iterator<WeakReference<zzq<?>>> iterator = this.zzagi.iterator();
                while (iterator.hasNext()) {
                    zzq zzq2 = (zzq)iterator.next().get();
                    if (zzq2 == null) continue;
                    zzq2.cancel();
                }
                this.zzagi.clear();
                return;
            }
        }
    }
}

