/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzp;
import com.google.android.gms.tasks.zzq;
import com.google.android.gms.tasks.zzr;
import com.google.android.gms.tasks.zzs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzp<TResult> zzp2 = new zzp<TResult>();
        zzp2.zza(TResult);
        return zzp2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzp zzp2 = new zzp();
        zzp2.zza(exception);
        return zzp2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        zzbq.zza((Object)executor, (Object)"Executor must not be null");
        zzbq.zza(callable, (Object)"Callback must not be null");
        zzp zzp2 = new zzp();
        executor.execute(new zzq(zzp2, callable));
        return zzp2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzbq.zzc((String)"Must not be called on the main application thread");
        zzbq.zza(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zza(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        zza2.zza();
        return Tasks.zza(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzbq.zzc((String)"Must not be called on the main application thread");
        zzbq.zza(task, (Object)"Task must not be null");
        zzbq.zza((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zza(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        if (!zza2.zza(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zza(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzp();
        zzc zzc2 = new zzc(collection.size(), (zzp<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWith(new zzr(collection));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArray) {
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    public static Task<List<Task<?>>> whenAllComplete(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWith(new zzs(collection));
    }

    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zza(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zza, zzb2);
        task.addOnFailureListener(TaskExecutors.zza, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    static final class zzc
    implements zzb {
        private final Object zza = new Object();
        private final int zzb;
        private final zzp<Void> zzc;
        private int zzd;
        private int zze;
        private Exception zzf;

        public zzc(int n, zzp<Void> zzp2) {
            this.zzb = n;
            this.zzc = zzp2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.zza;
            synchronized (object) {
                ++this.zze;
                this.zzf = exception;
                this.zza();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.zza;
            synchronized (object2) {
                ++this.zzd;
                this.zza();
                return;
            }
        }

        private final void zza() {
            if (this.zzd + this.zze == this.zzb) {
                if (this.zzf == null) {
                    this.zzc.zza((Void)null);
                    return;
                }
                int n = this.zze;
                int n2 = this.zzb;
                this.zzc.zza(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzf));
            }
        }
    }

    static final class zza
    implements zzb {
        private final CountDownLatch zza = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zza.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zza.countDown();
        }

        public final void zza() throws InterruptedException {
            this.zza.await();
        }

        public final boolean zza(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zza.await(l, timeUnit);
        }

        /* synthetic */ zza(zzq zzq2) {
            this();
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

