/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzn;
import com.google.android.gms.tasks.zzo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzn<TResult> zzn2 = new zzn<TResult>();
        zzn2.setResult(TResult);
        return zzn2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzn zzn2 = new zzn();
        zzn2.setException(exception);
        return zzn2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        zzbq.checkNotNull((Object)executor, (Object)"Executor must not be null");
        zzbq.checkNotNull(callable, (Object)"Callback must not be null");
        zzn zzn2 = new zzn();
        executor.execute(new zzo(zzn2, callable));
        return zzn2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzbq.zzgj((String)"Must not be called on the main application thread");
        zzbq.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzc(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzc(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzbq.zzgj((String)"Must not be called on the main application thread");
        zzbq.checkNotNull(task, (Object)"Task must not be null");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzc(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzc(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzn();
        zzc zzc2 = new zzc(collection.size(), (zzn<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzc(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zzksd, zzb2);
        task.addOnFailureListener(TaskExecutors.zzksd, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    static final class zzc
    implements zzb {
        private final Object mLock = new Object();
        private final int zzksj;
        private final zzn<Void> zzksc;
        private int zzksk;
        private int zzksl;
        private Exception zzksh;

        public zzc(int n, zzn<Void> zzn2) {
            this.zzksj = n;
            this.zzksc = zzn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.zzksl;
                this.zzksh = exception;
                this.zzbjc();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.mLock;
            synchronized (object2) {
                ++this.zzksk;
                this.zzbjc();
                return;
            }
        }

        private final void zzbjc() {
            if (this.zzksk + this.zzksl == this.zzksj) {
                if (this.zzksh == null) {
                    this.zzksc.setResult(null);
                    return;
                }
                int n = this.zzksl;
                int n2 = this.zzksj;
                this.zzksc.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzksh));
            }
        }
    }

    static final class zza
    implements zzb {
        private final CountDownLatch zzaoi = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zzaoi.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zzaoi.countDown();
        }

        public final void await() throws InterruptedException {
            this.zzaoi.await();
        }

        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zzaoi.await(l, timeUnit);
        }

        /* synthetic */ zza(zzo zzo2) {
            this();
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

