/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.pay;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.pay.zzy;
import java.lang.ref.WeakReference;

public final class zzz
extends zzy {
    private final WeakReference zza;
    private final int zzb;

    public zzz(Activity activity, int n) {
        this.zza = new WeakReference<Activity>(activity);
        this.zzb = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzh(Status status) {
        Intent intent;
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.d((String)"PayClientImpl", (String)"Ignoring onPendingIntent, Activity is gone");
            return;
        }
        if (status.hasResolution()) {
            try {
                status.startResolutionForResult(activity, this.zzb);
                return;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.w((String)"PayClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
            }
        }
        if ((activity = activity.createPendingResult(this.zzb, intent = new Intent(), 0x40000000)) == null) {
            Log.w((String)"PayClientImpl", (String)"Null pending result returned for onPendingIntent");
            return;
        }
        try {
            int n = status.isSuccess();
            n = n != 0 ? -1 : status.getStatusCode();
            activity.send(n);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"PayClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }
}

