/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_text_common.zzh;
import com.google.android.gms.internal.mlkit_vision_text_common.zzp;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.internal.zzj;
import com.google.mlkit.vision.text.internal.zzl;

final class zzd
implements zzl {
    private final Context zza;
    private final zzp zzb = new zzp(null);
    private boolean zzc;
    @Nullable
    private zzh zzd;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Text zza(InputImage inputImage) throws MlKitException {
        int n;
        Bitmap bitmap;
        if (zzlArray.zzd == null) {
            zzlArray.zzb();
        }
        if (zzlArray.zzd == null) {
            throw new MlKitException("Waiting for the text recognition module to be downloaded. Please wait.", 14);
        }
        if (inputImage.getFormat() == -1) {
            bitmap = inputImage.getBitmapInternal();
            n = CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees());
        } else {
            bitmap = ImageConvertUtils.getInstance().convertToUpRightBitmap(inputImage);
            n = 0;
        }
        bitmap = ObjectWrapper.wrap((Object)bitmap);
        com.google.android.gms.internal.mlkit_vision_text_common.zzd zzd2 = new com.google.android.gms.internal.mlkit_vision_text_common.zzd(inputImage.getWidth(), inputImage.getHeight(), 0, 0L, n);
        try {
            com.google.android.gms.internal.mlkit_vision_text_common.zzl[] zzlArray = ((zzh)Preconditions.checkNotNull((Object)zzlArray.zzd)).zze((IObjectWrapper)bitmap, zzd2);
            return zzj.zza(zzlArray, inputImage.getCoordinatesMatrix());
        }
        catch (RemoteException remoteException) {
            throw new MlKitException("Failed to run legacy text recognizer.", 13, (Throwable)remoteException);
        }
    }

    zzd(Context context) {
        this.zza = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void zzb() throws MlKitException {
        zzh zzh2;
        if (this.zzd != null) return;
        zzh2 = this.zzd = (zzh2 = com.google.android.gms.internal.mlkit_vision_text_common.zzj.zza(DynamiteModule.load((Context)this.zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.vision.dynamite").instantiate("com.google.android.gms.vision.text.ChimeraNativeTextRecognizerCreator")).zzd(ObjectWrapper.wrap((Object)this.zza), this.zzb));
        if (zzh2 != null) return;
        boolean bl = this.zzc;
        if (bl) return;
        try {
            Log.d((String)"LegacyTextDelegate", (String)"Request OCR optional module download.");
            OptionalModuleUtils.requestDownload((Context)this.zza, (String)"ocr");
            this.zzc = true;
            return;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            throw new MlKitException("Failed to load deprecated vision dynamite module.", 13, (Throwable)loadingException);
        }
        catch (RemoteException remoteException) {
            throw new MlKitException("Failed to create legacy text recognizer.", 13, (Throwable)remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzc() {
        zzh zzh2 = this.zzd;
        if (zzh2 == null) {
            return;
        }
        try {
            zzh2.zzd();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"LegacyTextDelegate", (String)"Failed to release legacy text recognizer.", (Throwable)remoteException);
        }
        this.zzd = null;
    }
}

