/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_text_common.zzmv;
import com.google.android.gms.internal.mlkit_vision_text_common.zzrd;
import com.google.android.gms.internal.mlkit_vision_text_common.zzrr;
import com.google.android.gms.internal.mlkit_vision_text_common.zzru;
import com.google.android.gms.internal.mlkit_vision_text_common.zzrw;
import com.google.android.gms.internal.mlkit_vision_text_common.zzry;
import com.google.android.gms.internal.mlkit_vision_text_common.zzrz;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsg;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsi;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.internal.LoggingUtils;
import com.google.mlkit.vision.text.internal.TextOptionalModuleUtils;
import com.google.mlkit.vision.text.internal.zzb;
import com.google.mlkit.vision.text.internal.zzl;

final class zzc
implements zzl {
    private final Context zza;
    private final TextRecognizerOptionsInterface zzb;
    private boolean zzc;
    private boolean zzd;
    private final zzrd zze;
    @Nullable
    private zzrw zzf;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final Text zza(InputImage inputImage) throws MlKitException {
        Object object;
        if (((zzc)object).zzf == null) {
            ((zzc)object).zzb();
        }
        Object object2 = (zzrw)Preconditions.checkNotNull((Object)((zzc)object).zzf);
        if (!((zzc)object).zzc) {
            try {
                object2.zze();
                ((zzc)object).zzc = true;
            }
            catch (RemoteException remoteException) {
                object = String.valueOf(((zzc)object).zzb.getLoggingLibraryName());
                throw new MlKitException("Failed to init text recognizer ".concat((String)object), 13, (Throwable)remoteException);
            }
        }
        Object object3 = new zzrr(inputImage.getFormat(), inputImage.getWidth(), inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        IObjectWrapper iObjectWrapper = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object2 = object2.zzd(iObjectWrapper, (zzrr)((Object)object3));
            return new Text((zzsg)((Object)object2), inputImage.getCoordinatesMatrix());
        }
        catch (RemoteException remoteException) {
            object = String.valueOf(((zzc)object).zzb.getLoggingLibraryName());
            throw new MlKitException("Failed to run text recognizer ".concat((String)object), 13, (Throwable)remoteException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzsi zzd(TextRecognizerOptionsInterface textRecognizerOptionsInterface, @Nullable String string) {
        int n;
        String string2 = textRecognizerOptionsInterface.getConfigLabel();
        String string3 = textRecognizerOptionsInterface.getLoggingLibraryNameForOptionalModule();
        switch (textRecognizerOptionsInterface.getLoggingLanguageOption()) {
            default: {
                n = 1;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 7: {
                n = 8;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 6: {
                n = 7;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 5: {
                n = 6;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 4: {
                n = 5;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 3: {
                n = 4;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 2: {
                n = 3;
                return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
            }
            case 1: 
        }
        n = 2;
        return new zzsi(string2, string3, string, true, n + -1, textRecognizerOptionsInterface.getLanguageHint());
    }

    zzc(Context context, TextRecognizerOptionsInterface textRecognizerOptionsInterface, zzrd zzrd2) {
        this.zza = context;
        this.zzb = textRecognizerOptionsInterface;
        this.zze = zzrd2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzb() throws MlKitException {
        if (((zzc)((Object)string)).zzf != null) return;
        try {
            Object object = ((zzc)((Object)string)).zzb;
            boolean bl = object instanceof zzb;
            object = bl ? ((zzb)object).zza() : null;
            int n = ((zzc)((Object)string)).zzb.getIsThickClient();
            if (n != 0) {
                object = zzry.zza(DynamiteModule.load((Context)((zzc)((Object)string)).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_LOCAL, (String)((zzc)((Object)string)).zzb.getModuleId()).instantiate("com.google.mlkit.vision.text.bundled.common.BundledTextRecognizerCreator")).zze(ObjectWrapper.wrap((Object)((zzc)((Object)string)).zza), com.google.mlkit.vision.text.internal.zzc.zzd(((zzc)((Object)string)).zzb, (String)object));
            } else if (bl) {
                object = zzru.zza(DynamiteModule.load((Context)((zzc)((Object)string)).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)((zzc)((Object)string)).zzb.getModuleId()).instantiate("com.google.android.gms.vision.text.mlkit.CommonTextRecognizerCreator")).zzd(ObjectWrapper.wrap((Object)((zzc)((Object)string)).zza), null, com.google.mlkit.vision.text.internal.zzc.zzd(((zzc)((Object)string)).zzb, (String)object));
            } else {
                zzrz zzrz2 = zzry.zza(DynamiteModule.load((Context)((zzc)((Object)string)).zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)((zzc)((Object)string)).zzb.getModuleId()).instantiate("com.google.android.gms.vision.text.mlkit.TextRecognizerCreator"));
                n = ((zzc)((Object)string)).zzb.getLoggingLanguageOption();
                object = n == 1 ? zzrz2.zzd(ObjectWrapper.wrap((Object)((zzc)((Object)string)).zza)) : zzrz2.zze(ObjectWrapper.wrap((Object)((zzc)((Object)string)).zza), com.google.mlkit.vision.text.internal.zzc.zzd(((zzc)((Object)string)).zzb, (String)object));
            }
            ((zzc)((Object)string)).zzf = object;
            LoggingUtils.zzb(((zzc)((Object)string)).zze, ((zzc)((Object)string)).zzb.getIsThickClient(), zzmv.zza);
            return;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            LoggingUtils.zzb(((zzc)((Object)string)).zze, ((zzc)((Object)string)).zzb.getIsThickClient(), zzmv.zzB);
            if (((zzc)((Object)string)).zzb.getIsThickClient()) {
                Object[] objectArray = new Object[]{((zzc)((Object)string)).zzb.getLoggingLibraryName(), loadingException.getMessage()};
                throw new MlKitException(String.format("Failed to load text module %s. %s", objectArray), 13, (Throwable)loadingException);
            }
        }
        catch (RemoteException remoteException) {
            LoggingUtils.zzb(((zzc)((Object)string)).zze, ((zzc)((Object)string)).zzb.getIsThickClient(), zzmv.zzC);
            String string = String.valueOf(((zzc)((Object)string)).zzb.getLoggingLibraryName());
            throw new MlKitException("Failed to create text recognizer ".concat(string), 13, (Throwable)remoteException);
        }
        if (((zzc)((Object)string)).zzd) {
            throw new MlKitException("Waiting for the text optional module to be downloaded. Please wait.", 14);
        }
        OptionalModuleUtils.requestDownload((Context)((zzc)((Object)string)).zza, (Feature[])TextOptionalModuleUtils.zza(((zzc)((Object)string)).zzb));
        ((zzc)((Object)string)).zzd = true;
        throw new MlKitException("Waiting for the text optional module to be downloaded. Please wait.", 14);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzc() {
        zzrw zzrw2 = this.zzf;
        if (zzrw2 != null) {
            try {
                zzrw2.zzf();
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf(this.zzb.getLoggingLibraryName());
                Log.e((String)"DecoupledTextDelegate", (String)"Failed to release text recognizer ".concat(string), (Throwable)remoteException);
            }
            this.zzf = null;
        }
        this.zzc = false;
    }
}

