/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.mlkit_vision_text_common.zzbx;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsa;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsc;
import com.google.android.gms.internal.mlkit_vision_text_common.zzse;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsg;
import com.google.android.gms.internal.mlkit_vision_text_common.zzsk;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.text.zza;
import com.google.mlkit.vision.text.zzb;
import com.google.mlkit.vision.text.zzc;
import com.google.mlkit.vision.text.zzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Text {
    private final List zza = new ArrayList();
    private final String zzb;

    @NonNull
    public String getText() {
        return this.zzb;
    }

    @NonNull
    public List<TextBlock> getTextBlocks() {
        return Collections.unmodifiableList(this.zza);
    }

    public Text(@NonNull String string, @NonNull List list) {
        this.zza.addAll(list);
        this.zzb = string;
    }

    public Text(@NonNull zzsg zzsg2, @Nullable Matrix matrix) {
        this.zzb = zzsg2.zza();
        this.zza.addAll(zzbx.zza(zzsg2.zzb(), new zza(matrix)));
    }

    public static class TextBlock
    extends TextBase {
        @GuardedBy(value="this")
        private final List zza;

        @NonNull
        public String getText() {
            return this.zza();
        }

        @NonNull
        public synchronized List<Line> getLines() {
            return this.zza;
        }

        public TextBlock(@NonNull String string, @NonNull Rect rect, @NonNull List list, @NonNull String string2, @Nullable Matrix matrix, @NonNull List list2) {
            super(string, rect, list, string2, matrix);
            this.zza = list2;
        }

        TextBlock(@NonNull zzsa zzsa2, @Nullable Matrix matrix) {
            super(zzsa2.zzc(), zzsa2.zza(), zzsa2.zzd(), zzsa2.zzb(), matrix);
            this.zza = zzbx.zza(zzsa2.zze(), new zzd(matrix));
        }
    }

    static class TextBase {
        private final String zza;
        private final Rect zzb;
        private final Point[] zzc;
        private final String zzd;

        @Nullable
        public Rect getBoundingBox() {
            return this.zzb;
        }

        @NonNull
        public String getRecognizedLanguage() {
            return this.zzd;
        }

        TextBase(String string, Rect pointArray, List list, String string2, @Nullable Matrix matrix) {
            this.zza = string;
            super((Rect)pointArray);
            if (matrix != null) {
                CommonConvertUtils.transformRect((Rect)string, (Matrix)matrix);
            }
            this.zzb = string;
            pointArray = new Point[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                pointArray[i] = new Point((Point)list.get(i));
            }
            if (matrix != null) {
                CommonConvertUtils.transformPointArray((Point[])pointArray, (Matrix)matrix);
            }
            this.zzc = pointArray;
            this.zzd = string2;
        }

        @Nullable
        public Point[] getCornerPoints() {
            return this.zzc;
        }

        @NonNull
        protected final String zza() {
            String string = ((TextBase)((Object)string)).zza;
            if (string == null) {
                return "";
            }
            return string;
        }
    }

    public static class Symbol
    extends TextBase {
        private final float zza;
        private final float zzb;

        public float getAngle() {
            return this.zzb;
        }

        public float getConfidence() {
            return this.zza;
        }

        @NonNull
        public String getText() {
            return this.zza();
        }

        Symbol(@NonNull zzsk zzsk2, @Nullable Matrix matrix) {
            super(zzsk2.zzd(), zzsk2.zzc(), zzsk2.zze(), "", matrix);
            this.zza = zzsk2.zzb();
            this.zzb = zzsk2.zza();
        }
    }

    public static class Element
    extends TextBase {
        @GuardedBy(value="this")
        private final List zza;
        private final float zzb;
        private final float zzc;

        public float getAngle() {
            return this.zzc;
        }

        public float getConfidence() {
            return this.zzb;
        }

        @NonNull
        public String getText() {
            return this.zza();
        }

        @NonNull
        public synchronized List<Symbol> getSymbols() {
            return this.zza;
        }

        public Element(@NonNull String string, @NonNull Rect rect, @NonNull List list, @NonNull String string2, @Nullable Matrix matrix, float f, float f2, @NonNull List list2) {
            super(string, rect, list, string2, matrix);
            this.zzb = f;
            this.zzc = f2;
            this.zza = list2;
        }

        Element(@NonNull zzsc object, @Nullable Matrix matrix) {
            super(object.zze(), object.zzc(), object.zzf(), object.zzd(), matrix);
            this.zzb = object.zzb();
            this.zzc = object.zza();
            object = object.zzg();
            if (object == null) {
                object = new ArrayList();
            }
            this.zza = zzbx.zza((List)object, new zzb(matrix));
        }
    }

    public static class Line
    extends TextBase {
        @GuardedBy(value="this")
        private final List zza;
        private final float zzb;
        private final float zzc;

        public float getAngle() {
            return this.zzc;
        }

        public float getConfidence() {
            return this.zzb;
        }

        @NonNull
        public String getText() {
            return this.zza();
        }

        @NonNull
        public synchronized List<Element> getElements() {
            return this.zza;
        }

        public Line(@NonNull String string, @NonNull Rect rect, @NonNull List list, @NonNull String string2, @Nullable Matrix matrix, @NonNull List list2, float f, float f2) {
            super(string, rect, list, string2, matrix);
            this.zza = list2;
            this.zzb = f;
            this.zzc = f2;
        }

        Line(@NonNull zzse zzse2, @Nullable Matrix matrix, float f, float f2) {
            super(zzse2.zze(), zzse2.zzc(), zzse2.zzf(), zzse2.zzd(), matrix);
            this.zza = zzbx.zza(zzse2.zzg(), new zzc(matrix));
            this.zzb = f;
            this.zzc = f2;
        }
    }
}

