/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_text_common.zzd;
import com.google.android.gms.internal.mlkit_vision_text_common.zzh;
import com.google.android.gms.internal.mlkit_vision_text_common.zzj;
import com.google.android.gms.internal.mlkit_vision_text_common.zzl;
import com.google.android.gms.internal.mlkit_vision_text_common.zzp;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.internal.zzi;
import com.google.mlkit.vision.text.internal.zzk;

final class zzc
implements zzk {
    private final Context zza;
    private final zzp zzb;
    private boolean zzc;
    @Nullable
    private zzh zzd;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Text zza(InputImage object) throws MlKitException {
        int n;
        Bitmap bitmap;
        zzl[] zzlArray;
        if (zzlArray.zzd == null) {
            zzlArray.zzb();
        }
        if (zzlArray.zzd == null) {
            zzlArray = new MlKitException("Waiting for the text recognition module to be downloaded. Please wait.", 14);
            throw zzlArray;
        }
        if (object.getFormat() == -1) {
            bitmap = object.getBitmapInternal();
            n = CommonConvertUtils.convertToMVRotation((int)object.getRotationDegrees());
        } else {
            bitmap = ImageConvertUtils.getInstance().convertToUpRightBitmap(object);
            n = 0;
        }
        bitmap = ObjectWrapper.wrap((Object)bitmap);
        zzd zzd2 = new zzd(object.getWidth(), object.getHeight(), 0, 0L, n);
        try {
            zzlArray = ((zzh)Preconditions.checkNotNull((Object)zzlArray.zzd)).zze((IObjectWrapper)bitmap, zzd2);
            return zzi.zza(zzlArray, object.getCoordinatesMatrix());
        }
        catch (RemoteException remoteException) {
            MlKitException mlKitException = new MlKitException("Failed to run legacy text recognizer.", 13, (Throwable)remoteException);
            throw mlKitException;
        }
    }

    zzc(Context context) {
        zzp zzp2;
        this.zzb = zzp2 = new zzp(null);
        this.zza = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void zzb() throws MlKitException {
        zzh zzh2;
        if (this.zzd != null) return;
        zzh2 = this.zzd = (zzh2 = zzj.zza(DynamiteModule.load((Context)this.zza, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.vision.dynamite").instantiate("com.google.android.gms.vision.text.ChimeraNativeTextRecognizerCreator")).zzd(ObjectWrapper.wrap((Object)this.zza), this.zzb));
        if (zzh2 != null) return;
        boolean bl = this.zzc;
        if (bl) return;
        try {
            Log.d((String)"LegacyTextDelegate", (String)"Request OCR optional module download.");
            OptionalModuleUtils.requestDownload((Context)this.zza, (String)"ocr");
            this.zzc = true;
            return;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            MlKitException mlKitException = new MlKitException("Failed to load deprecated vision dynamite module.", 13, (Throwable)loadingException);
            throw mlKitException;
        }
        catch (RemoteException remoteException) {
            MlKitException mlKitException = new MlKitException("Failed to create legacy text recognizer.", 13, (Throwable)remoteException);
            throw mlKitException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzc() {
        zzh zzh2 = this.zzd;
        if (zzh2 == null) {
            return;
        }
        try {
            zzh2.zzd();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"LegacyTextDelegate", (String)"Failed to release legacy text recognizer.", (Throwable)remoteException);
        }
        this.zzd = null;
    }
}

