/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_text_common.zzks;
import com.google.android.gms.internal.mlkit_vision_text_common.zzog;
import com.google.android.gms.internal.mlkit_vision_text_common.zzou;
import com.google.android.gms.internal.mlkit_vision_text_common.zzow;
import com.google.android.gms.internal.mlkit_vision_text_common.zzoy;
import com.google.android.gms.internal.mlkit_vision_text_common.zzpg;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.internal.LoggingUtils;
import com.google.mlkit.vision.text.internal.zzk;

final class zzb
implements zzk {
    private final Context zza;
    private final TextRecognizerOptionsInterface zzb;
    private boolean zzc;
    private boolean zzd;
    private final zzog zze;
    @Nullable
    private zzow zzf;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final Text zza(InputImage inputImage) throws MlKitException {
        Object object;
        if (((zzb)object).zzf == null) {
            ((zzb)object).zzb();
        }
        Object object2 = (zzow)Preconditions.checkNotNull((Object)((zzb)object).zzf);
        if (!((zzb)object).zzc) {
            try {
                object2.zze();
                ((zzb)object).zzc = true;
            }
            catch (RemoteException remoteException) {
                object = ((zzb)object).zzb;
                object = object.getLoggingLibraryName();
                object2 = new MlKitException("Failed to init text recognizer ".concat(String.valueOf(object)), 13, (Throwable)remoteException);
                throw object2;
            }
        }
        Object object3 = new zzou(inputImage.getFormat(), inputImage.getWidth(), inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        IObjectWrapper iObjectWrapper = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object2 = object2.zzd(iObjectWrapper, (zzou)((Object)object3));
            return new Text((zzpg)((Object)object2), inputImage.getCoordinatesMatrix());
        }
        catch (RemoteException remoteException) {
            object = ((zzb)object).zzb;
            object = object.getLoggingLibraryName();
            object2 = new MlKitException("Failed to run text recognizer ".concat(String.valueOf(object)), 13, (Throwable)remoteException);
            throw object2;
        }
    }

    zzb(Context context, TextRecognizerOptionsInterface textRecognizerOptionsInterface, zzog zzog2) {
        this.zza = context;
        this.zzb = textRecognizerOptionsInterface;
        this.zze = zzog2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    @WorkerThread
    public final void zzb() throws MlKitException {
        if (this.zzf != null) return;
        try {
            void var1_9;
            zzow zzow2;
            Context context = this.zza;
            boolean bl = this.zzb.getIsThickClient();
            if (bl) {
                DynamiteModule.VersionPolicy versionPolicy = DynamiteModule.PREFER_LOCAL;
            } else {
                DynamiteModule.VersionPolicy versionPolicy = DynamiteModule.PREFER_REMOTE;
            }
            this.zzf = zzow2 = zzoy.zza(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)var1_9, (String)this.zzb.getModuleId()).instantiate(this.zzb.getCreatorClass())).zzd(ObjectWrapper.wrap((Object)this.zza));
            LoggingUtils.zzb(this.zze, this.zzb.getIsThickClient(), zzks.zza);
            return;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            LoggingUtils.zzb(this.zze, this.zzb.getIsThickClient(), zzks.zzB);
            if (this.zzb.getIsThickClient()) {
                Object[] objectArray = new Object[]{this.zzb.getLoggingLibraryName(), loadingException.getMessage()};
                MlKitException mlKitException = new MlKitException(String.format("Failed to load text module %s. %s", objectArray), 13, (Throwable)loadingException);
                throw mlKitException;
            }
        }
        catch (RemoteException remoteException) {
            LoggingUtils.zzb(this.zze, this.zzb.getIsThickClient(), zzks.zzC);
            TextRecognizerOptionsInterface textRecognizerOptionsInterface = this.zzb;
            String string = textRecognizerOptionsInterface.getLoggingLibraryName();
            MlKitException mlKitException = new MlKitException("Failed to create text recognizer ".concat(String.valueOf(string)), 13, (Throwable)remoteException);
            throw mlKitException;
        }
        if (!this.zzd) {
            OptionalModuleUtils.requestDownload((Context)this.zza, (String)"ocr");
            this.zzd = true;
        }
        MlKitException mlKitException = new MlKitException("Waiting for the text optional module to be downloaded. Please wait.", 14);
        throw mlKitException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzc() {
        zzow zzow2 = this.zzf;
        if (zzow2 != null) {
            try {
                zzow2.zzf();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"DecoupledTextDelegate", (String)"Failed to release text recognizer ".concat(String.valueOf(this.zzb.getLoggingLibraryName())), (Throwable)remoteException);
            }
            this.zzf = null;
        }
        this.zzc = false;
    }
}

