/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzdy {
    private static volatile zzdy zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzjl, zzb>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdj zzj;

    public final int zza(String string) {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzev(this, string, zzdk2));
        Integer n = (Integer)zzdk.zza((Bundle)zzdk2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzeq(this, zzdk2));
        Long l = zzdk2.zzb(500L);
        if (l == null) {
            zzdy zzdy2 = this;
            return new Random(System.nanoTime() ^ zzdy2.zza.currentTimeMillis()).nextLong() + (long)(++zzdy2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzew(this, bundle, zzdk2));
        if (bl) {
            return zzdk2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdj zza(zzdy zzdy2) {
        return zzdy2.zzj;
    }

    protected final @Nullable zzdj zza(Context context, boolean bl) {
        try {
            return zzdm.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzdy zza(@NonNull Context context) {
        return zzdy.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzdy zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzdy> clazz = zzdy.class;
        synchronized (zzdy.class) {
            if (zzb != null) return zzb;
            zzb = new zzdy(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzex(this, zzdk2));
        return zzdk2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzfa(this, zzdk2, n));
        return zzdk.zza((Bundle)zzdk2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzdy zzdy2) {
        return zzdy2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzey(this, zzdk2));
        return zzdk2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzen(this, zzdk2));
        return zzdk2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzes(this, zzdk2));
        return zzdk2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzep(this, zzdk2));
        return zzdk2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzeo(this, zzdk2));
        return zzdk2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzeb(this, string, string2, zzdk2));
        List list = (List)zzdk.zza((Bundle)zzdk2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzdk zzdk2 = new zzdk();
        this.zza(new zzer(this, string, string2, bl, zzdk2));
        Bundle bundle = zzdk2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzdy zzdy2, zzdj zzdj2) {
        zzdy2.zzj = zzdj2;
    }

    private zzdy(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzdy zzdy2 = this;
        this.zzd = zzdc.zza().zza(new zzek(zzdy2), 1);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zzjl, zzb>>();
        Context context2 = context;
        zzdy2 = this;
        if (!(!zzdy.zzb(context2) || zzdy2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdx(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzdy2 = this;
        if (context2 == null) {
            Log.w((String)zzdy2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdy2.new zzd());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzem(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzec(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzel(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzff(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzeu(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzjl zzjl2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzjl2);
        List<Pair<zzjl, zzb>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzjl2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzb2 = new zzb(zzjl2);
            this.zzf.add((Pair<zzjl, zzb>)new Pair((Object)zzjl2, (Object)zzb2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdp)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfe(this, zzb2));
    }

    public final void zzj() {
        this.zza(new zzeh(this));
    }

    private final void zza(zza zza2) {
        this.zzd.execute(zza2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzdz(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzef(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzei(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzed(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzez(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzfc(this, bundle));
    }

    public final void zza(zzjm zzjm2) {
        zzc zzc2 = new zzc(zzjm2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdp)zzc2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzet(this, zzc2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzeg(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzej(this, l));
    }

    public final void zza(Intent intent) {
        this.zza(new zzfb(this, intent));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzee(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzea(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzjl zzjl2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzjl2);
        List<Pair<zzjl, zzb>> list = this.zzf;
        synchronized (list) {
            Pair<zzjl, zzb> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzjl2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzb2 = (zzb)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdp)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfd(this, zzb2));
    }

    static /* synthetic */ boolean zza(zzdy zzdy2, String string, String string2) {
        return zzdy2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzhs.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzhs(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zza
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.zza = zzdy.this.zza.currentTimeMillis();
            this.zzb = zzdy.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzdy.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzdy.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zzc
    extends zzds {
        private final zzjm zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzc(zzjm zzjm2) {
            this.zza = zzjm2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzb
    extends zzds {
        private final zzjl zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzb(zzjl zzjl2) {
            this.zza = zzjl2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzdy.this.zza(new zzfg(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzdy.this.zza(new zzfl(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzdy.this.zza(new zzfk(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzdy.this.zza(new zzfh(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzdk zzdk2 = new zzdk();
            zzdy.this.zza(new zzfm(this, activity, zzdk2));
            Bundle bundle2 = zzdk2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzdy.this.zza(new zzfi(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzdy.this.zza(new zzfj(this, activity));
        }
    }
}

