/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzdv {
    private static volatile zzdv zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzjj, zzd>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdk zzj;

    public final int zza(String string) {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzew(this, string, zzdi2));
        Integer n = (Integer)zzdi.zza((Bundle)zzdi2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzen(this, zzdi2));
        Long l = zzdi2.zzb(500L);
        if (l == null) {
            zzdv zzdv2 = this;
            return new Random(System.nanoTime() ^ zzdv2.zza.currentTimeMillis()).nextLong() + (long)(++zzdv2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzet(this, bundle, zzdi2));
        if (bl) {
            return zzdi2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdk zza(zzdv zzdv2) {
        return zzdv2.zzj;
    }

    protected final @Nullable zzdk zza(Context context, boolean bl) {
        try {
            return zzdj.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzdv zza(@NonNull Context context) {
        return zzdv.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzdv zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzdv> clazz = zzdv.class;
        synchronized (zzdv.class) {
            if (zzb != null) return zzb;
            zzb = new zzdv(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzey(this, zzdi2));
        return zzdi2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzex(this, zzdi2, n));
        return zzdi.zza((Bundle)zzdi2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzdv zzdv2) {
        return zzdv2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzev(this, zzdi2));
        return zzdi2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzeo(this, zzdi2));
        return zzdi2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzep(this, zzdi2));
        return zzdi2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzeq(this, zzdi2));
        return zzdi2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzel(this, zzdi2));
        return zzdi2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzec(this, string, string2, zzdi2));
        List list = (List)zzdi.zza((Bundle)zzdi2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzdi zzdi2 = new zzdi();
        this.zza(new zzes(this, string, string2, bl, zzdi2));
        Bundle bundle = zzdi2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzdv zzdv2, zzdk zzdk2) {
        zzdv2.zzj = zzdk2;
    }

    private zzdv(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzdv zzdv2 = this;
        this.zzd = zzcz.zza().zza(new zzeh(zzdv2), 1);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zzjj, zzd>>();
        Context context2 = context;
        zzdv2 = this;
        if (!(!zzdv.zzb(context2) || zzdv2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdy(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzdv2 = this;
        if (context2 == null) {
            Log.w((String)zzdv2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdv2.new zzc());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzej(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzdz(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzem(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzfd(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzer(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzjj zzjj2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zzjj2);
        List<Pair<zzjj, zzd>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzjj2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzd2 = new zzd(zzjj2);
            this.zzf.add((Pair<zzjj, zzd>)new Pair((Object)zzjj2, (Object)zzd2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdq)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfb(this, zzd2));
    }

    public final void zzj() {
        this.zza(new zzei(this));
    }

    private final void zza(zzb zzb2) {
        this.zzd.execute(zzb2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzea(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzeg(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzef(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzee(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzfa(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzez(this, bundle));
    }

    public final void zza(zzjg zzjg2) {
        zza zza2 = new zza(zzjg2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdq)zza2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzeu(this, zza2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzed(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzek(this, l));
    }

    public final void zza(Intent intent) {
        this.zza(new zzfc(this, intent));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzeb(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzdx(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzjj zzjj2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zzjj2);
        List<Pair<zzjj, zzd>> list = this.zzf;
        synchronized (list) {
            Pair<zzjj, zzd> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzjj2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzd2 = (zzd)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdq)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfe(this, zzd2));
    }

    static /* synthetic */ boolean zza(zzdv zzdv2, String string, String string2) {
        return zzdv2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzhq.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzhq(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zzb
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.zza = zzdv.this.zza.currentTimeMillis();
            this.zzb = zzdv.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzdv.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzdv.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zza
    extends zzdp {
        private final zzjg zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zza(zzjg zzjg2) {
            this.zza = zzjg2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzd
    extends zzdp {
        private final zzjj zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzd(zzjj zzjj2) {
            this.zza = zzjj2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzc
    implements Application.ActivityLifecycleCallbacks {
        zzc() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzdv.this.zza(new zzfg(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzdv.this.zza(new zzfl(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzdv.this.zza(new zzfh(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzdv.this.zza(new zzfi(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzdi zzdi2 = new zzdi();
            zzdv.this.zza(new zzfj(this, activity, zzdi2));
            Bundle bundle2 = zzdi2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzdv.this.zza(new zzff(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzdv.this.zza(new zzfk(this, activity));
        }
    }
}

