/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjd;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgo
extends zzjd {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzgq zzd = new zzgq(this, 6, false, false);
    private final zzgq zze = new zzgq(this, 6, true, false);
    private final zzgq zzf = new zzgq(this, 6, false, true);
    private final zzgq zzg = new zzgq(this, 5, false, false);
    private final zzgq zzh = new zzgq(this, 5, true, false);
    private final zzgq zzi = new zzgq(this, 5, false, true);
    private final zzgq zzj = new zzgq(this, 4, false, false);
    private final zzgq zzk = new zzgq(this, 3, false, false);
    private final zzgq zzl = new zzgq(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzgo zzgo2) {
        return zzgo2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzgo zzgo2) {
        return zzgo2.zzb;
    }

    public final zzgq zzc() {
        return this.zzk;
    }

    public final zzgq zzg() {
        return this.zzd;
    }

    public final zzgq zzm() {
        return this.zzf;
    }

    public final zzgq zzn() {
        return this.zze;
    }

    public final zzgq zzo() {
        return this.zzj;
    }

    public final zzgq zzp() {
        return this.zzl;
    }

    public final zzgq zzu() {
        return this.zzg;
    }

    public final zzgq zzv() {
        return this.zzi;
    }

    public final zzgq zzw() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzgp(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzgo.zza(bl, object);
        String string3 = zzgo.zza(bl, object2);
        String string4 = zzgo.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzgo.zzb(zzhy.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzgo.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzgp) {
            return zzgp.zza((zzgp)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            if (zzok.zza() && ((Boolean)zzbh.zzcg.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzx() {
        if (((zzja)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzja)this).zzk().zzb.zza();
        if (pair == null || pair == zzha.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzy() {
        zzgo zzgo2 = this;
        synchronized (zzgo2) {
            if (this.zzc == null) {
                String string;
                zzgo zzgo3;
                if (this.zzu.zzw() != null) {
                    zzgo3 = this;
                    string = this.zzu.zzw();
                } else {
                    zzgo3 = this;
                    string = "FA";
                }
                zzgo3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzgo zzgo2, long l) {
        zzgo2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzgo zzgo2, char c) {
        zzgo2.zza = c;
    }

    zzgo(zzhy zzhy2) {
        super(zzhy2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzgo.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzgo zzgo2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzhv zzhv2 = zzgo2.zzu.zzo();
            if (zzhv2 == null) {
                zzgo2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzhv2.zzaf()) {
                zzgo2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzhv2.zzb(new zzgn(zzgo2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzy(), (String)string);
    }

    @VisibleForTesting
    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzy(), (int)n);
    }

    @Override
    protected final boolean zzh() {
        return false;
    }
}

