/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.android.gms.internal.measurement.zzha;
import com.google.android.gms.internal.measurement.zzhb;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzgu
implements zzhb {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzgu> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzgw(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzgz> zzi = new ArrayList<zzgz>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgu zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzgu> clazz = zzgu.class;
        synchronized (zzgu.class) {
            zzgu zzgu2 = zza.get(uri);
            if (zzgu2 == null) {
                try {
                    zzgu2 = new zzgu(contentResolver, uri, runnable);
                    zza.put(uri, zzgu2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzgu2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final /* synthetic */ Map zzb() {
        ContentProviderClient contentProviderClient = this.zzc.acquireUnstableContentProviderClient(this.zzd);
        if (contentProviderClient == null) {
            Log.w((String)"ConfigurationContentLdr", (String)"Unable to acquire ContentProviderClient, using default values");
            return Collections.emptyMap();
        }
        try {
            Object object;
            Cursor cursor;
            block23: {
                Map map;
                block24: {
                    int n;
                    block21: {
                        Map map2;
                        block22: {
                            block19: {
                                Map map3;
                                block20: {
                                    cursor = contentProviderClient.query(this.zzd, zzb, null, null, null);
                                    if (cursor != null) break block19;
                                    Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query returned null cursor, using default values");
                                    map3 = Collections.emptyMap();
                                    if (cursor == null) break block20;
                                    cursor.close();
                                }
                                return map3;
                            }
                            n = cursor.getCount();
                            if (n != 0) break block21;
                            map2 = Collections.emptyMap();
                            if (cursor == null) break block22;
                            cursor.close();
                        }
                        return map2;
                    }
                    try {
                        Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
                        while (cursor.moveToNext()) {
                            object.put(cursor.getString(0), cursor.getString(1));
                        }
                        if (cursor.isAfterLast()) break block23;
                        Log.w((String)"ConfigurationContentLdr", (String)"Cursor read incomplete (ContentProvider dead?), using default values");
                        map = Collections.emptyMap();
                        if (cursor == null) break block24;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (cursor != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (RemoteException remoteException) {
                            Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query failed, using default values", (Throwable)remoteException);
                            Map map4 = Collections.emptyMap();
                            return map4;
                        }
                    }
                    cursor.close();
                }
                return map;
            }
            Object object3 = object;
            if (cursor != null) {
                cursor.close();
            }
            return object3;
        }
        finally {
            contentProviderClient.release();
        }
    }

    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzgu zzgu2 = this;
            Map map = (Map)zzha.zza(new zzgx(zzgu2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.w((String)"ConfigurationContentLdr", (String)"Unable to query ContentProvider, using default values", (Throwable)throwable);
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzgu(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzc() {
        for (zzgu zzgu2 : zza.values()) {
            zzgu2.zzc.unregisterContentObserver(zzgu2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        zzgu zzgu2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzgu zzgu3 = zzgu2 = this;
        synchronized (zzgu2) {
            Iterator<zzgz> iterator = zzgu2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

