/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zznp;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzks
extends zze {
    private volatile @Nullable zzkp zzb;
    private volatile @Nullable zzkp zzc;
    @VisibleForTesting
    protected @Nullable zzkp zza;
    private final Map<Activity, zzkp> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzkp zzg;
    private @Nullable zzkp zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzkp zza(zzks zzks2) {
        return zzks2.zzh;
    }

    @MainThread
    private final zzkp zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzkp zzkp2 = this.zzd.get(activity);
        if (zzkp2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzkp2 = new zzkp(null, string, ((zzij)this).zzq().zzm());
            this.zzd.put(activity, zzkp2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzkp2;
    }

    public final @Nullable zzkp zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzkp zza(boolean bl) {
        this.zzu();
        ((zzij)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzks zzks2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzij)zzks2).zze().zza(null, false)) {
            return string4.substring(0, ((zzij)zzks2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkp zzkp2) {
        zzks2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkp zzkp2, zzkp zzkp3, long l, boolean bl, Bundle bundle) {
        zzks2.zza(zzkp2, zzkp3, l, bl, null);
    }

    static /* synthetic */ void zza(zzks zzks2, Bundle bundle, zzkp zzkp2, zzkp zzkp3, long l) {
        long l2 = l;
        zzkp zzkp4 = zzkp3;
        zzkp zzkp5 = zzkp2;
        Bundle bundle2 = bundle;
        zzks zzks3 = zzks2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzij)zzks3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzks3.zza(zzkp5, zzkp4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkp zzkp2, boolean bl, long l) {
        zzks2.zza(zzkp2, false, l);
    }

    public zzks(zzhj zzhj2) {
        super(zzhj2);
        this.zzd = new ConcurrentHashMap<Activity, zzkp>();
    }

    @MainThread
    private final void zza(Activity activity, zzkp zzkp2, boolean bl) {
        zzkp zzkp3;
        zzkp zzkp4;
        zzkp zzkp5 = zzkp4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzkp2.zzb == null) {
            zzkp3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzkp2 = new zzkp(zzkp2.zza, (String)((Object)zzkp3), zzkp2.zzc, zzkp2.zze, zzkp2.zzf);
        }
        zzkp3 = zzkp2;
        this.zzc = this.zzb;
        this.zzb = zzkp3;
        long l = ((zzij)this).zzb().elapsedRealtime();
        ((zzij)this).zzl().zzb(new zzku(this, zzkp3, zzkp4, l, bl));
    }

    @WorkerThread
    private final void zza(zzkp zzkp2, @Nullable zzkp zzkp3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzij)this).zzt();
        boolean bl3 = zzkp3 == null || zzkp3.zzc != zzkp2.zzc || !Objects.equals(zzkp3.zzb, zzkp2.zzb) || !Objects.equals(zzkp3.zza, zzkp2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zznp.zza(zzkp2, bundle2, true);
            if (zzkp3 != null) {
                if (zzkp3.zza != null) {
                    bundle2.putString("_pn", zzkp3.zza);
                }
                if (zzkp3.zzb != null) {
                    bundle2.putString("_pc", zzkp3.zzb);
                }
                bundle2.putLong("_pi", zzkp3.zzc);
            }
            if (bl2 && (l3 = ((zzf)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzij)this).zzq().zza(bundle2, l3);
            }
            if (!((zzij)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzkp2.zze ? "app" : "auto";
            long l4 = ((zzij)this).zzb().currentTimeMillis();
            if (zzkp2.zze && zzkp2.zzf != 0L) {
                l4 = zzkp2.zzf;
            }
            ((zzf)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzkp2;
        if (zzkp2.zze) {
            this.zzh = zzkp2;
        }
        ((zzf)this).zzo().zza(zzkp2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzkp zzkp2 = new zzkp(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzkp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzij)this).zzb().elapsedRealtime();
        if (!((zzij)this).zze().zzv()) {
            this.zzb = null;
            ((zzij)this).zzl().zzb(new zzkw(this, l));
            return;
        }
        zzkp zzkp2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzij)this).zzl().zzb(new zzkv(this, zzkp2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzf zzf2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzf2 = this;
                Object object2 = ((zzks)zzf2).zzj;
                synchronized (object2) {
                    ((zzks)zzf2).zze = activity2;
                    ((zzks)zzf2).zzf = false;
                }
                if (zzf2.zze().zzv()) {
                    ((zzks)zzf2).zzg = null;
                    zzf2.zzl().zzb(new zzky((zzks)zzf2));
                }
            }
        }
        if (!((zzij)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzij)this).zzl().zzb(new zzkt(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzkp)object, false);
        zzf2 = ((zzf)this).zzc();
        long l = zzf2.zzb().elapsedRealtime();
        zzf2.zzl().zzb(new zzc((zzb)zzf2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzkp zzkp2 = this.zzd.get(activity);
        if (zzkp2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzkp2.zzc);
        bundle2.putString("name", zzkp2.zza);
        bundle2.putString("referrer_name", zzkp2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzkp zzkp2, boolean bl, long l) {
        boolean bl2;
        ((zzf)this).zzc().zza(((zzij)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzkp2 != null && zzkp2.zzd;
        if (((zzf)this).zzp().zza(bl2, bl, l) && zzkp2 != null) {
            zzkp2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzij)this).zze().zzv()) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzkp zzkp2 = this.zzb;
        if (zzkp2 == null) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzkp2.zzb, string2);
        boolean bl2 = Objects.equals(zzkp2.zza, string);
        if (bl && bl2) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzij)this).zze().zza(null, false))) {
            ((zzij)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzij)this).zze().zza(null, false))) {
            ((zzij)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzij)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzkp zzkp3 = new zzkp(string, string2, ((zzij)this).zzq().zzm());
        this.zzd.put(activity, zzkp3);
        this.zza(activity, zzkp3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzkp zzkp2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzij)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzij)this).zze().zza(null, false))) {
                    ((zzij)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzij)this).zze().zza(null, false))) {
                    ((zzij)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzkp2 = this.zzb;
            if (this.zzf && zzkp2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzkp2.zzb, string2);
                boolean bl2 = Objects.equals(zzkp2.zza, string);
                if (bl && bl2) {
                    ((zzij)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzij)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzkp2 = new zzkp(string, string2, ((zzij)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzkp2;
        long l2 = ((zzij)this).zzb().elapsedRealtime();
        ((zzij)this).zzl().zzb(new zzkr(this, bundle, zzkp2, (zzkp)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

