/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhc
extends zzii {
    private static final AtomicLong zza = new AtomicLong(Long.MIN_VALUE);
    @Nullable
    private zzhg zzb;
    @Nullable
    private zzhg zzc;
    private final PriorityBlockingQueue<zzhh<?>> zzd;
    private final BlockingQueue<zzhh<?>> zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;

    static /* bridge */ /* synthetic */ zzhg zza(zzhc zzhc2) {
        return zzhc2.zzc;
    }

    static /* bridge */ /* synthetic */ zzhg zzb(zzhc zzhc2) {
        return zzhc2.zzb;
    }

    static /* bridge */ /* synthetic */ Object zzc(zzhc zzhc2) {
        return zzhc2.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzij)this).zzl().zzb(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = string;
                ((zzij)this).zzj().zzu().zza("Interrupted waiting for " + string2);
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = string;
            ((zzij)this).zzj().zzu().zza("Timed out waiting for " + string3);
        }
        return (T)atomicReference2;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzac();
        Preconditions.checkNotNull(callable);
        zzhh zzhh2 = new zzhh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                ((zzij)this).zzj().zzu().zza("Callable skipped the worker queue.");
            }
            zzhh2.run();
        } else {
            this.zza(zzhh2);
        }
        return zzhh2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzac();
        Preconditions.checkNotNull(callable);
        zzhh zzhh2 = new zzhh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            zzhh2.run();
        } else {
            this.zza(zzhh2);
        }
        return zzhh2;
    }

    static /* bridge */ /* synthetic */ Semaphore zzd(zzhc zzhc2) {
        return zzhc2.zzi;
    }

    static /* bridge */ /* synthetic */ AtomicLong zzc() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zza(zzhc zzhc2, zzhg zzhg2) {
        zzhc2.zzc = null;
    }

    static /* bridge */ /* synthetic */ void zzb(zzhc zzhc2, zzhg zzhg2) {
        zzhc2.zzb = null;
    }

    zzhc(zzhj zzhj2) {
        super(zzhj2);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        this.zzf = new zzhe(this, "Thread death: Uncaught exception on worker thread");
        this.zzg = new zzhe(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    public final void zzr() {
        if (Thread.currentThread() != this.zzc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    @Override
    public final void zzt() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzhh<?> zzhh2) {
        Object object = this.zzh;
        synchronized (object) {
            this.zzd.add(zzhh2);
            if (this.zzb == null) {
                this.zzb = new zzhg(this, "Measurement Worker", this.zzd);
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                this.zzb.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzac();
        Preconditions.checkNotNull((Object)runnable);
        zzhh zzhh2 = new zzhh(this, runnable, false, "Task exception on network thread");
        zzhc zzhc2 = this;
        Object object = zzhc2.zzh;
        synchronized (object) {
            zzhc2.zze.add(zzhh2);
            if (zzhc2.zzc == null) {
                zzhc2.zzc = new zzhg(zzhc2, "Measurement Network", zzhc2.zze);
                zzhc2.zzc.setUncaughtExceptionHandler(zzhc2.zzg);
                zzhc2.zzc.start();
            } else {
                zzhc2.zzc.zza();
            }
            return;
        }
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzac();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzhh(this, runnable, false, "Task exception on worker thread"));
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzac();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzhh(this, runnable, true, "Task exception on worker thread"));
    }

    static /* bridge */ /* synthetic */ boolean zze(zzhc zzhc2) {
        return zzhc2.zzj;
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zzb;
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

