/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzop;
import com.google.android.gms.internal.measurement.zzou;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzim;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzag
extends zzij {
    private @Nullable Boolean zza;
    private @Nullable String zzb;
    private zzai zzc = new zzaf();
    private @MonotonicNonNull Boolean zzd;

    @WorkerThread
    public final double zza(@Nullable String string, zzfj<Double> zzfj2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfj2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfj2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfj2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzfj2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfj2.zza(null);
        }
    }

    final int zzc() {
        if (zzou.zza()) {
            zzfj<Boolean> zzfj2 = zzbf.zzbx;
            if (((zzij)this).zze().zzf(null, zzfj2)) {
                if (((zzij)this).zzq().zza(231100000, true)) {
                    return 35;
                }
                return 0;
            }
        }
        return 0;
    }

    final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzbf.zzah, 500, 2000);
    }

    final int zza(@Nullable String string, boolean bl) {
        if (zzop.zza()) {
            zzfj<Boolean> zzfj2 = zzbf.zzcn;
            if (((zzij)this).zze().zzf(null, zzfj2)) {
                if (bl) {
                    return this.zza(string, zzbf.zzar, 100, 500);
                }
                return 500;
            }
        }
        return 100;
    }

    final int zzb(@Nullable String string, boolean bl) {
        return Math.max(this.zza(string, bl), 256);
    }

    public final int zzg() {
        if (((zzij)this).zzq().zza(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzb(@Size(min=1L) String string) {
        return this.zza(string, zzbf.zzai, 25, 100);
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzbf.zzo);
    }

    @WorkerThread
    public final int zzb(@Nullable String string, zzfj<Integer> zzfj2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfj2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfj2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfj2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzfj2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfj2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(@Nullable String string, zzfj<Integer> zzfj2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzfj2), n2), n);
    }

    @WorkerThread
    final long zzd(String string) {
        return this.zzc(string, zzbf.zza);
    }

    public static long zzh() {
        return zzbf.zzd.zza(null);
    }

    public static long zzm() {
        return zzbf.zzad.zza(null);
    }

    @WorkerThread
    public final long zzc(@Nullable String string, zzfj<Long> zzfj2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfj2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfj2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfj2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzfj2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfj2.zza(null);
        }
    }

    @VisibleForTesting
    private final @Nullable Bundle zzz() {
        try {
            if (((zzij)this).zza().getPackageManager() == null) {
                ((zzij)this).zzj().zzg().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzij)this).zza()).getApplicationInfo(((zzij)this).zza().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzij)this).zzj().zzg().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzij)this).zzj().zzg().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final zzim zzc(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzz();
        if (bundle == null) {
            ((zzij)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            object2 = null;
        } else {
            object2 = object = bundle.get(string2);
        }
        if (object2 == null) {
            return zzim.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzim.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzim.zzc;
        }
        if (bl && "eu_consent_policy".equals(object)) {
            return zzim.zzb;
        }
        ((zzij)this).zzj().zzu().zza("Invalid manifest metadata for", string);
        return zzim.zza;
    }

    @VisibleForTesting
    final @Nullable Boolean zze(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzij)this).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzn() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzo() {
        return this.zza("debug.deferred.deeplink", "");
    }

    @WorkerThread
    public final String zzd(@Nullable String string, zzfj<String> zzfj2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfj2.zza(null);
        }
        return zzfj2.zza(this.zzc.zza(string, zzfj2.zza()));
    }

    public final @Nullable String zzp() {
        return this.zzb;
    }

    @WorkerThread
    final String zzf(String string) {
        return this.zzd(string, zzbf.zzal);
    }

    private final String zza(String string, String string2) {
        try {
            String string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string3);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzij)this).zzj().zzg().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzij)this).zzj().zzg().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzij)this).zzj().zzg().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzij)this).zzj().zzg().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    @VisibleForTesting
    final @Nullable List<String> zzg(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzz();
        if (bundle == null) {
            ((zzij)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzij)this).zza().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzij)this).zzj().zzg().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzag(zzhj zzhj2) {
        super(zzhj2);
    }

    final void zza(zzai zzai2) {
        this.zzc = zzai2;
    }

    public final void zzh(@Nullable String string) {
        this.zzb = string;
    }

    public final boolean zzu() {
        Boolean bl = this.zze("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzf(string, zzbf.zzak);
    }

    public final boolean zza(zzfj<Boolean> zzfj2) {
        zzfj<Boolean> zzfj3 = zzfj2;
        return this.zzf(null, zzfj3);
    }

    public final boolean zze(@Nullable String string, zzfj<Boolean> zzfj2) {
        return this.zzf(string, zzfj2);
    }

    @WorkerThread
    public final boolean zzf(@Nullable String string, zzfj<Boolean> zzfj2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfj2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfj2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfj2.zza(null);
        }
        return zzfj2.zza("1".equals(string2));
    }

    public final boolean zzj(String string) {
        return "1".equals(this.zzc.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzv() {
        Boolean bl = this.zze("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final boolean zzw() {
        Boolean bl = this.zze("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzc.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzx() {
        if (this.zza == null) {
            this.zza = this.zze("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzy() {
        if (this.zzd == null) {
            zzag zzag2 = this;
            synchronized (zzag2) {
                if (this.zzd == null) {
                    ApplicationInfo applicationInfo = ((zzij)this).zza().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzd = string2 != null && string2.equals(string);
                    }
                    if (this.zzd == null) {
                        this.zzd = Boolean.TRUE;
                        ((zzij)this).zzj().zzg().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzd;
    }
}

