/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzny;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzky
extends zze {
    private volatile @Nullable zzkv zzb;
    private volatile @Nullable zzkv zzc;
    @VisibleForTesting
    protected @Nullable zzkv zza;
    private final Map<Activity, zzkv> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzkv zzg;
    private @Nullable zzkv zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzkv zza(zzky zzky2) {
        return zzky2.zzh;
    }

    @MainThread
    private final zzkv zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzkv zzkv2 = this.zzd.get(activity);
        if (zzkv2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzkv2 = new zzkv(null, string, ((zzim)this).zzq().zzm());
            this.zzd.put(activity, zzkv2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzkv2;
    }

    public final @Nullable zzkv zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzkv zza(boolean bl) {
        this.zzu();
        ((zzim)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzky zzky2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzim)zzky2).zze().zza(null, false)) {
            return string4.substring(0, ((zzim)zzky2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzky zzky2, zzkv zzkv2) {
        zzky2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzky zzky2, zzkv zzkv2, zzkv zzkv3, long l, boolean bl, Bundle bundle) {
        zzky2.zza(zzkv2, zzkv3, l, bl, null);
    }

    static /* synthetic */ void zza(zzky zzky2, Bundle bundle, zzkv zzkv2, zzkv zzkv3, long l) {
        long l2 = l;
        zzkv zzkv4 = zzkv3;
        zzkv zzkv5 = zzkv2;
        Bundle bundle2 = bundle;
        zzky zzky3 = zzky2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzim)zzky3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzky3.zza(zzkv5, zzkv4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzky zzky2, zzkv zzkv2, boolean bl, long l) {
        zzky2.zza(zzkv2, false, l);
    }

    public zzky(zzhm zzhm2) {
        super(zzhm2);
        this.zzd = new ConcurrentHashMap<Activity, zzkv>();
    }

    @MainThread
    private final void zza(Activity activity, zzkv zzkv2, boolean bl) {
        zzkv zzkv3;
        zzkv zzkv4;
        zzkv zzkv5 = zzkv4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzkv2.zzb == null) {
            zzkv3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzkv2 = new zzkv(zzkv2.zza, (String)((Object)zzkv3), zzkv2.zzc, zzkv2.zze, zzkv2.zzf);
        }
        zzkv3 = zzkv2;
        this.zzc = this.zzb;
        this.zzb = zzkv3;
        long l = ((zzim)this).zzb().elapsedRealtime();
        ((zzim)this).zzl().zzb(new zzla(this, zzkv3, zzkv4, l, bl));
    }

    @WorkerThread
    private final void zza(zzkv zzkv2, @Nullable zzkv zzkv3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzim)this).zzt();
        boolean bl3 = zzkv3 == null || zzkv3.zzc != zzkv2.zzc || !Objects.equals(zzkv3.zzb, zzkv2.zzb) || !Objects.equals(zzkv3.zza, zzkv2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzny.zza(zzkv2, bundle2, true);
            if (zzkv3 != null) {
                if (zzkv3.zza != null) {
                    bundle2.putString("_pn", zzkv3.zza);
                }
                if (zzkv3.zzb != null) {
                    bundle2.putString("_pc", zzkv3.zzb);
                }
                bundle2.putLong("_pi", zzkv3.zzc);
            }
            if (bl2 && (l3 = ((zzf)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzim)this).zzq().zza(bundle2, l3);
            }
            if (!((zzim)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzkv2.zze ? "app" : "auto";
            long l4 = ((zzim)this).zzb().currentTimeMillis();
            if (zzkv2.zze && zzkv2.zzf != 0L) {
                l4 = zzkv2.zzf;
            }
            ((zzf)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzkv2;
        if (zzkv2.zze) {
            this.zzh = zzkv2;
        }
        ((zzf)this).zzo().zza(zzkv2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzkv zzkv2 = new zzkv(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzkv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzim)this).zzb().elapsedRealtime();
        if (!((zzim)this).zze().zzv()) {
            this.zzb = null;
            ((zzim)this).zzl().zzb(new zzlc(this, l));
            return;
        }
        zzkv zzkv2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzim)this).zzl().zzb(new zzlb(this, zzkv2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzf zzf2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzf2 = this;
                Object object2 = ((zzky)zzf2).zzj;
                synchronized (object2) {
                    ((zzky)zzf2).zze = activity2;
                    ((zzky)zzf2).zzf = false;
                }
                if (zzf2.zze().zzv()) {
                    ((zzky)zzf2).zzg = null;
                    zzf2.zzl().zzb(new zzle((zzky)zzf2));
                }
            }
        }
        if (!((zzim)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzim)this).zzl().zzb(new zzkz(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzkv)object, false);
        zzf2 = ((zzf)this).zzc();
        long l = zzf2.zzb().elapsedRealtime();
        zzf2.zzl().zzb(new zzc((zzb)zzf2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzkv zzkv2 = this.zzd.get(activity);
        if (zzkv2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzkv2.zzc);
        bundle2.putString("name", zzkv2.zza);
        bundle2.putString("referrer_name", zzkv2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzkv zzkv2, boolean bl, long l) {
        boolean bl2;
        ((zzf)this).zzc().zza(((zzim)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzkv2 != null && zzkv2.zzd;
        if (((zzf)this).zzp().zza(bl2, bl, l) && zzkv2 != null) {
            zzkv2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzim)this).zze().zzv()) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzkv zzkv2 = this.zzb;
        if (zzkv2 == null) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzkv2.zzb, string2);
        boolean bl2 = Objects.equals(zzkv2.zza, string);
        if (bl && bl2) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzim)this).zze().zza(null, false))) {
            ((zzim)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzim)this).zze().zza(null, false))) {
            ((zzim)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzim)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzkv zzkv3 = new zzkv(string, string2, ((zzim)this).zzq().zzm());
        this.zzd.put(activity, zzkv3);
        this.zza(activity, zzkv3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzkv zzkv2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzim)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzim)this).zze().zza(null, false))) {
                    ((zzim)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzim)this).zze().zza(null, false))) {
                    ((zzim)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzkv2 = this.zzb;
            if (this.zzf && zzkv2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzkv2.zzb, string2);
                boolean bl2 = Objects.equals(zzkv2.zza, string);
                if (bl && bl2) {
                    ((zzim)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzim)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzkv2 = new zzkv(string, string2, ((zzim)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzkv2;
        long l2 = ((zzim)this).zzb().elapsedRealtime();
        ((zzim)this).zzl().zzb(new zzkx(this, bundle, zzkv2, (zzkv)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

