/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlm
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzfs zzc;
    final /* synthetic */ zzkp zza;

    static /* bridge */ /* synthetic */ void zza(zzlm zzlm2, boolean bl) {
        zzlm2.zzb = false;
    }

    protected zzlm(zzkp zzkp2) {
        this.zza = zzkp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzid)this.zza).zzt();
        Context context = ((zzid)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzlm zzlm2 = this;
        synchronized (zzlm2) {
            if (this.zzb) {
                ((zzid)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzid)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzkp.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzid)this.zza).zzt();
        Context context = ((zzid)this.zza).zza();
        zzlm zzlm2 = this;
        synchronized (zzlm2) {
            if (this.zzb) {
                ((zzid)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzid)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfs(context, Looper.getMainLooper(), this, this);
            ((zzid)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzlm zzlm2 = this;
        synchronized (zzlm2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfk zzfk2 = (zzfk)this.zzc.getService();
                ((zzid)this.zza).zzl().zzb(new zzln(this, zzfk2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfr zzfr2 = this.zza.zzu.zzm();
        if (zzfr2 != null) {
            zzfr2.zzu().zza("Service connection failed", connectionResult);
        }
        zzlm zzlm2 = this;
        synchronized (zzlm2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzid)this.zza).zzl().zzb(new zzlp(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzid)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzid)this.zza).zzl().zzb(new zzlq(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzlm zzlm2 = this;
        synchronized (zzlm2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzid)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfk zzfk2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfk2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfk ? (zzfk)iInterface : new zzfm(iBinder2));
                    ((zzid)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzid)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzid)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfk2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzid)this.zza).zza(), (ServiceConnection)zzkp.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfk2;
                ((zzid)this.zza).zzl().zzb(new zzll(this, (zzfk)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzid)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzid)this.zza).zzl().zzb(new zzlo(this, componentName));
    }
}

