/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkp
extends zze {
    private final zzlm zza;
    private @Nullable zzfk zzb;
    private volatile Boolean zzc;
    private final zzaw zzd;
    private final zzmi zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaw zzg;

    @WorkerThread
    private final @Nullable zzo zzb(boolean bl) {
        return ((zzf)this).zzg().zza(bl ? ((zzid)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzam zzaa() {
        ((zzid)this).zzt();
        this.zzu();
        zzfk zzfk2 = this.zzb;
        if (zzfk2 == null) {
            this.zzad();
            ((zzid)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzo zzo2 = this.zzb(false);
        Preconditions.checkNotNull((Object)((Object)zzo2));
        try {
            zzam zzam2 = zzfk2.zza(zzo2);
            this.zzal();
            return zzam2;
        }
        catch (RemoteException remoteException) {
            ((zzid)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfk zza(zzkp zzkp2) {
        return zzkp2.zzb;
    }

    static /* bridge */ /* synthetic */ zzlm zzb(zzkp zzkp2) {
        return zzkp2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzkp zzkp2, zzfk zzfk2) {
        zzkp2.zzb = null;
    }

    static /* synthetic */ void zzc(zzkp zzkp2) {
        zzkp2.zzak();
    }

    static /* synthetic */ void zzd(zzkp zzkp2) {
        zzkp zzkp3 = zzkp2;
        ((zzid)zzkp3).zzt();
        if (zzkp3.zzah()) {
            ((zzid)zzkp3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzkp3.zzae();
        }
    }

    static /* synthetic */ void zza(zzkp zzkp2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzkp zzkp3 = zzkp2;
        ((zzid)zzkp3).zzt();
        if (zzkp3.zzb != null) {
            zzkp3.zzb = null;
            ((zzid)zzkp3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzkp zzkp4 = zzkp3;
            ((zzid)zzkp4).zzt();
            zzkp4.zzad();
        }
    }

    static /* synthetic */ void zze(zzkp zzkp2) {
        zzkp2.zzal();
    }

    protected zzkp(zzhf zzhf2) {
        super(zzhf2);
        this.zze = new zzmi(zzhf2.zzb());
        this.zza = new zzlm(this);
        this.zzd = new zzks(this, zzhf2);
        this.zzg = new zzlb(this, zzhf2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(true);
        ((zzf)this).zzh().zzab();
        this.zza(new zzla(this, zzo2));
    }

    @WorkerThread
    final void zzad() {
        ((zzid)this).zzt();
        this.zzu();
        if (this.zzah()) {
            return;
        }
        if (this.zzam()) {
            this.zza.zza();
            return;
        }
        if (!((zzid)this).zze().zzw()) {
            Intent intent;
            zzkp zzkp2 = this;
            PackageManager packageManager = ((zzid)zzkp2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzid)zzkp2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzid)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzid)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzid)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzid)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzak() {
        ((zzid)this).zzt();
        ((zzid)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzid)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzcv zzcv2) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkx(this, zzo2, zzcv2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzky(this, atomicReference, zzo2));
    }

    @WorkerThread
    protected final void zza(zzcv zzcv2, @Nullable String string, @Nullable String string2) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlk(this, string, string2, zzo2, zzcv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzad>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlh(this, atomicReference, string, string2, string3, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmh>> atomicReference, Bundle bundle) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkt(this, atomicReference, zzo2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zznc>> atomicReference, boolean bl) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzku(this, atomicReference, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzcv zzcv2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkr(this, string, string2, zzo2, bl, zzcv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zznc>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlj(this, atomicReference, string, string2, string3, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzbg zzbg2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbg2));
        ((zzid)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzbg2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzlf(this, true, zzo2, bl, zzbg2, string));
    }

    @WorkerThread
    public final void zza(zzcv zzcv2, zzbg zzbg2, String string) {
        ((zzid)this).zzt();
        this.zzu();
        if (((zzid)this).zzq().zza(12451000) != 0) {
            ((zzid)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzid)this).zzq().zza(zzcv2, new byte[0]);
            return;
        }
        this.zza(new zzle(this, zzbg2, string, zzcv2));
    }

    @WorkerThread
    private final void zzal() {
        ((zzid)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbi.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzaf() {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        ((zzf)this).zzh().zzaa();
        this.zza(new zzkv(this, zzo2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzid)this).zzt();
        if (this.zzah()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzid)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfk zzfk2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzo zzo2) {
        ((zzid)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzf)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbg) {
                    try {
                        zzfk2.zza((zzbg)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzid)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zznc) {
                    try {
                        zzfk2.zza((zznc)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzid)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzad) {
                    try {
                        zzfk2.zza((zzad)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzid)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzid)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzad zzad2) {
        Preconditions.checkNotNull((Object)((Object)zzad2));
        ((zzid)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzad2);
        zzad zzad3 = new zzad(zzad2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzli(this, true, zzo2, bl, zzad3, zzad2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzid)this).zzt();
        this.zzu();
        if (bl) {
            ((zzf)this).zzh().zzaa();
        }
        if (this.zzaj()) {
            zzo zzo2 = this.zzb(false);
            this.zza(new zzlg(this, zzo2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzki zzki2) {
        ((zzid)this).zzt();
        this.zzu();
        this.zza(new zzkz(this, zzki2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlc(this, zzo2, bundle));
    }

    @WorkerThread
    protected final void zzag() {
        ((zzid)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(true);
        this.zza(new zzld(this, zzo2));
    }

    @WorkerThread
    protected final void zza(zzfk zzfk2) {
        ((zzid)this).zzt();
        Preconditions.checkNotNull((Object)zzfk2);
        this.zzb = zzfk2;
        this.zzal();
        this.zzak();
    }

    @WorkerThread
    protected final void zza(zznc zznc2) {
        ((zzid)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zznc2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzkw(this, zzo2, bl, zznc2));
    }

    @WorkerThread
    public final boolean zzah() {
        ((zzid)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzid)this).zzt();
        this.zzu();
        if (!this.zzam()) {
            return true;
        }
        return ((zzid)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzaj() {
        ((zzid)this).zzt();
        this.zzu();
        if (!this.zzam()) {
            return true;
        }
        return ((zzid)this).zzq().zzg() >= (Integer)zzbi.zzbo.zza(null);
    }

    @WorkerThread
    private final boolean zzam() {
        ((zzid)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzkp zzkp2 = this;
            ((zzid)zzkp2).zzt();
            zzkp2.zzu();
            Boolean bl2 = ((zzid)zzkp2).zzk().zzn();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzf)zzkp2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzid)zzkp2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzid)zzkp2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzid)zzkp2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzid)zzkp2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzid)zzkp2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzid)zzkp2).zzj().zzc().zza("Service container out of date");
                            if (((zzid)zzkp2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzid)zzkp2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzid)zzkp2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzid)zzkp2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzid)zzkp2).zze().zzw()) {
                    ((zzid)zzkp2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzid)zzkp2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

