/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzoo;
import com.google.android.gms.internal.measurement.zzot;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzid;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzaf
extends zzid {
    private @Nullable Boolean zza;
    private zzah zzb = zzai.zza;
    private @MonotonicNonNull Boolean zzc;

    @WorkerThread
    public final double zza(@Nullable String string, zzfi<Double> zzfi2) {
        if (string == null) {
            return zzfi2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfi2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzfi2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfi2.zza(null);
        }
    }

    final int zzc() {
        if (zzot.zza()) {
            zzfi<Boolean> zzfi2 = zzbi.zzcc;
            if (((zzid)this).zze().zzf(null, zzfi2)) {
                if (((zzid)this).zzq().zza(231100000, true)) {
                    return 35;
                }
                return 0;
            }
        }
        return 0;
    }

    final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzbi.zzah, 500, 2000);
    }

    final int zzb(@Nullable String string) {
        if (zzoo.zza()) {
            zzfi<Boolean> zzfi2 = zzbi.zzcu;
            if (((zzid)this).zze().zzf(null, zzfi2)) {
                return 500;
            }
        }
        return 100;
    }

    final int zzc(String string) {
        return Math.max(this.zzb(string), 256);
    }

    public final int zzg() {
        if (((zzid)this).zzq().zza(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzd(@Size(min=1L) String string) {
        return this.zza(string, zzbi.zzai, 25, 100);
    }

    @WorkerThread
    public final int zze(@Size(min=1L) String string) {
        return this.zzb(string, zzbi.zzo);
    }

    @WorkerThread
    public final int zzb(@Nullable String string, zzfi<Integer> zzfi2) {
        if (string == null) {
            return zzfi2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfi2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzfi2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfi2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(@Nullable String string, zzfi<Integer> zzfi2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzfi2), n2), n);
    }

    @WorkerThread
    final long zzf(String string) {
        return this.zzc(string, zzbi.zza);
    }

    public static long zzh() {
        return zzbi.zzd.zza(null);
    }

    public static long zzm() {
        return zzbi.zzad.zza(null);
    }

    @WorkerThread
    public final long zzc(@Nullable String string, zzfi<Long> zzfi2) {
        if (string == null) {
            return zzfi2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfi2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzfi2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfi2.zza(null);
        }
    }

    @VisibleForTesting
    private final @Nullable Bundle zzy() {
        try {
            if (((zzid)this).zza().getPackageManager() == null) {
                ((zzid)this).zzj().zzg().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzid)this).zza()).getApplicationInfo(((zzid)this).zza().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzid)this).zzj().zzg().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzid)this).zzj().zzg().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @VisibleForTesting
    final @Nullable Boolean zzg(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzy();
        if (bundle == null) {
            ((zzid)this).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzn() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzo() {
        return this.zza("debug.deferred.deeplink", "");
    }

    @WorkerThread
    public final String zzd(@Nullable String string, zzfi<String> zzfi2) {
        if (string == null) {
            return zzfi2.zza(null);
        }
        return zzfi2.zza(this.zzb.zza(string, zzfi2.zza()));
    }

    @WorkerThread
    final String zzh(String string) {
        return this.zzd(string, zzbi.zzal);
    }

    private final String zza(String string, String string2) {
        try {
            String string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string3);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzid)this).zzj().zzg().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzid)this).zzj().zzg().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzid)this).zzj().zzg().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzid)this).zzj().zzg().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    @VisibleForTesting
    final @Nullable List<String> zzi(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzaf zzaf2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzaf2.zzy();
        if (bundle == null) {
            ((zzid)zzaf2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzid)this).zza().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzid)this).zzj().zzg().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzaf(zzhf zzhf2) {
        super(zzhf2);
    }

    final void zza(zzah zzah2) {
        this.zzb = zzah2;
    }

    public final boolean zzp() {
        Boolean bl = this.zzg("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzf(string, zzbi.zzak);
    }

    public final boolean zza(zzfi<Boolean> zzfi2) {
        zzfi<Boolean> zzfi3 = zzfi2;
        return this.zzf(null, zzfi3);
    }

    public final boolean zze(@Nullable String string, zzfi<Boolean> zzfi2) {
        return this.zzf(string, zzfi2);
    }

    @WorkerThread
    public final boolean zzf(@Nullable String string, zzfi<Boolean> zzfi2) {
        if (string == null) {
            return zzfi2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfi2.zza(null);
        }
        return zzfi2.zza("1".equals(string2));
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzu() {
        Boolean bl = this.zzg("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final boolean zzv() {
        Boolean bl = this.zzg("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzl(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzw() {
        if (this.zza == null) {
            this.zza = this.zzg("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzx() {
        if (this.zzc == null) {
            zzaf zzaf2 = this;
            synchronized (zzaf2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzid)this).zza().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzid)this).zzj().zzg().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }
}

