/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzlb
extends zzgl {
    private static final String[] zza;
    private static final String[] zzb;
    private SecureRandom zzc;
    private final AtomicLong zzd;
    private int zze;
    private Integer zzf = null;

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zza(String object, String string, String string2, Object object2, Bundle bundle, List list, boolean bl, boolean bl2) {
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzgk)object3).zzg();
                                    if (!((zzlb)object3).zzaf(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzlb.zzas(string2, zzgp.zzc)) {
                                        return 20;
                                    }
                                    zzjm zzjm2 = ((zzlb)object3).zzt.zzt();
                                    ((zzgk)zzjm2).zzg();
                                    zzjm2.zza();
                                    if (zzjm2.zzN() && zzjm2.zzt.zzv().zzm() < 200900) {
                                        return 25;
                                    }
                                    ((zzgk)object3).zzt.zzf();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            ((zzgk)object3).zzt.zzay().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n3);
                            ((zzgk)object3).zzt.zzf();
                            if (!bl3) break block23;
                            Parcelable[] parcelableArray = (Parcelable[])object2;
                            if (parcelableArray.length > 200) {
                                bundle.putParcelableArray(string2, Arrays.copyOf(parcelableArray, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object2;
                            if (arrayList.size() > 200) {
                                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, 200));
                                bundle.putParcelableArrayList(string2, arrayList2);
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (zzlb.zzah(string) || zzlb.zzah(string2)) {
            ((zzgk)object3).zzt.zzf();
            n = 256;
        } else {
            ((zzgk)object3).zzt.zzf();
            n = 100;
        }
        if (((zzlb)object3).zzaa("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzlb)object3).zzW((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    ((zzgk)object3).zzt.zzay().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                    return 4;
                }
                ((zzlb)object3).zzW((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzgk)object3).zzt.zzay().zzl();
                Object object3 = e != null ? e.getClass() : "null";
                ((zzef)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzlb)object3).zzW((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzd(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzaa("user property referrer", string, this.zzaq(string), object) : this.zzaa("user property", string, this.zzaq(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zzh(String string) {
        if (!this.zzab("event", string)) {
            return 2;
        }
        if (!this.zzZ("event", zzgo.zza, zzgo.zzb, string)) {
            return 13;
        }
        this.zzt.zzf();
        if (!this.zzY("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzi(String string) {
        if (!this.zzab("event param", string)) {
            return 3;
        }
        if (!this.zzZ("event param", null, null, string)) {
            return 14;
        }
        this.zzt.zzf();
        if (!this.zzY("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string) {
        if (!this.zzac("event param", string)) {
            return 3;
        }
        if (!this.zzZ("event param", null, null, string)) {
            return 14;
        }
        this.zzt.zzf();
        if (!this.zzY("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzl(String string) {
        if (!this.zzab("user property", string)) {
            return 6;
        }
        if (!this.zzZ("user property", zzgq.zza, null, string)) {
            return 15;
        }
        this.zzt.zzf();
        if (!this.zzY("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzf == null) {
            this.zzf = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzt.zzau()) / 1000;
        }
        return this.zzf;
    }

    private final int zzaq(String string) {
        if ("_ldl".equals(string)) {
            this.zzt.zzf();
            return 2048;
        }
        if ("_id".equals(string)) {
            this.zzt.zzf();
            return 256;
        }
        if ("_lgclid".equals(string)) {
            this.zzt.zzf();
            return 100;
        }
        this.zzt.zzf();
        return 36;
    }

    public final int zzo(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzt.zzau(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzp(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        for (int i = n + -1; i >= 0 && i >= byArray.length + -8; n2 += 8, --i) {
            long l2 = l + (((long)byArray[i] & 0xFFL) << n2);
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq() {
        if (this.zzd.get() == 0L) {
            AtomicLong atomicLong = this.zzd;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzt.zzav();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zze;
                this.zze = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zzd;
        synchronized (atomicLong) {
            this.zzd.compareAndSet(-1L, 1L);
            return this.zzd.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final long zzr(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzs(Uri uri) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        if (uri == null) {
            return null;
        }
        try {
            Object object;
            boolean bl = uri.isHierarchical();
            if (bl) {
                string6 = uri.getQueryParameter("utm_campaign");
                string5 = uri.getQueryParameter("utm_source");
                string4 = uri.getQueryParameter("utm_medium");
                string3 = uri.getQueryParameter("gclid");
                string2 = uri.getQueryParameter("utm_id");
                string = uri.getQueryParameter("dclid");
                String string7 = uri.getQueryParameter("srsltid");
                object = string6;
                string6 = string5;
                string5 = string4;
                string4 = string3;
                string3 = string2;
                string2 = string;
                string = string7;
            } else {
                object = null;
                string6 = null;
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                string = null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzgk)object).zzt.zzay().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string6) && TextUtils.isEmpty((CharSequence)string5) && TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("campaign", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            bundle.putString("source", string6);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            bundle.putString("medium", string5);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            bundle.putString("gclid", string4);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_term")))) {
            bundle.putString("term", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_content")))) {
            bundle.putString("content", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("aclid")))) {
            bundle.putString("aclid", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("cp1")))) {
            bundle.putString("cp1", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("anid")))) {
            bundle.putString("anid", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("campaign_id", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("dclid", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_source_platform")))) {
            bundle.putString("source_platform", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_creative_format")))) {
            bundle.putString("creative_format", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_marketing_tactic")))) {
            bundle.putString("marketing_tactic", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("srsltid", string);
        }
        return bundle;
    }

    final Bundle zzt(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzA(string, bundle.get(string));
                if (object == null) {
                    this.zzt.zzay().zzl().zzb("Param value can't be null", this.zzt.zzj().zze(string));
                    continue;
                }
                this.zzO(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle zzy(String string, String string2, Bundle bundle, List list, boolean bl) {
        boolean bl2 = zzlb.zzas(string2, zzgo.zzd);
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = new Bundle(bundle);
        int n = this.zzt.zzf().zzc();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string3;
            int n3;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n3 = !bl ? this.zzj(string4) : 0;
                if (n3 == 0) {
                    n3 = this.zzi(string4);
                }
            } else {
                n3 = 0;
            }
            if (n3 != 0) {
                String string5 = n3 == 3 ? string4 : null;
                this.zzJ(bundle2, n3, string4, string4, string5);
                bundle2.remove(string4);
                continue;
            }
            int n4 = this.zza(string, string2, string4, bundle.get(string4), bundle2, list, bl, bl2);
            if (n4 == 17) {
                this.zzJ(bundle2, 17, string4, string4, false);
            } else if (n4 != 0 && !"_ev".equals(string4)) {
                string3 = n4 == 21 ? string2 : string4;
            }
            if (!zzlb.zzai(string4) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            this.zzt.zzay().zze().zzc(stringBuilder.toString(), this.zzt.zzj().zzd(string2), this.zzt.zzj().zzb(bundle));
            zzlb.zzao(bundle2, 5);
            bundle2.remove(string4);
            continue;
            this.zzJ(bundle2, n4, string3, string4, bundle.get(string4));
            bundle2.remove(string4);
        }
        return bundle2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final zzaw zzz(String object, String string, Bundle object2, String string2, long l, boolean bl, boolean bl2) {
        void var5_11;
        void var7_12;
        void var4_10;
        void var3_7;
        void var3_5;
        Object object3;
        void var2_4;
        if (TextUtils.isEmpty((CharSequence)var2_4)) {
            return null;
        }
        if (((zzlb)object3).zzh((String)var2_4) != 0) {
            ((zzgk)object3).zzt.zzay().zzd().zzb("Invalid conditional property event name", ((zzgk)object3).zzt.zzj().zzf((String)var2_4));
            object3 = new IllegalArgumentException();
            throw object3;
        }
        if (var3_5 != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = new Bundle((Bundle)var3_5);
        } else {
            Bundle bundle = new Bundle();
        }
        var3_7.putString("_o", (String)var4_10);
        Bundle bundle = ((zzlb)object3).zzy((String)object, (String)var2_4, (Bundle)var3_7, CollectionUtils.listOf((Object)"_o"), true);
        object3 = var7_12 != false ? ((zzlb)object3).zzt(bundle) : bundle;
        Preconditions.checkNotNull((Object)object3);
        zzau zzau2 = new zzau((Bundle)object3);
        return new zzaw((String)var2_4, zzau2, (String)var4_10, (long)var5_11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzA(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzt.zzf();
            return this.zzar(256, object, true, true);
        }
        if (zzlb.zzah(string)) {
            this.zzt.zzf();
            n = 256;
            return this.zzar(n, object, false, true);
        }
        this.zzt.zzf();
        n = 100;
        return this.zzar(n, object, false, true);
    }

    final Object zzB(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zzar(this.zzaq(string), object, true, false);
        }
        return this.zzar(this.zzaq(string), object, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzar(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzD(parcelableArray.toString(), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzt((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    final String zzC() {
        byte[] byArray = new byte[16];
        ((zzlb)((Object)locale)).zzG().nextBytes(byArray);
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        BigInteger bigInteger = new BigInteger(1, byArray);
        objectArray[0] = bigInteger;
        return String.format(locale, "%032x", objectArray);
    }

    public final String zzD(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzE(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            Object object3 = new Object[4];
            Object[] objectArray = new Object[]{74029L, this.zzm()};
            object3[0] = String.format("v%s.%s", objectArray);
            object3[1] = object;
            object3[2] = string;
            object3[3] = l2;
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", (Object[])object3);
            object3 = this.zzt.zzf();
            boolean bl = string.equals(((zzag)object3).zzm());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzt.zzay().zzd().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzF() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzG() {
        this.zzg();
        if (this.zzc == null) {
            SecureRandom secureRandom;
            this.zzc = secureRandom = new SecureRandom();
        }
        return this.zzc;
    }

    public static ArrayList zzH(List object) {
        if (object == null) {
            object = new ArrayList(0);
            return object;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzac)((Object)object.next());
            Bundle bundle = new Bundle();
            bundle.putString("app_id", abstractSafeParcelable.zza);
            bundle.putString("origin", abstractSafeParcelable.zzb);
            bundle.putLong("creation_timestamp", abstractSafeParcelable.zzd);
            bundle.putString("name", abstractSafeParcelable.zzc.zzb);
            zzgn.zzb((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)abstractSafeParcelable.zzc.zza()));
            bundle.putBoolean("active", abstractSafeParcelable.zze);
            Object object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", (String)object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzaw)((Object)object2)).zza);
                object2 = ((zzaw)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzau)object2).zzc());
                }
            }
            bundle.putLong("trigger_timeout", abstractSafeParcelable.zzh);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzaw)((Object)object2)).zza);
                object2 = ((zzaw)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzau)object2).zzc());
                }
            }
            bundle.putLong("triggered_timestamp", abstractSafeParcelable.zzc.zzc);
            bundle.putLong("time_to_live", abstractSafeParcelable.zzj);
            abstractSafeParcelable = abstractSafeParcelable.zzk;
            if (abstractSafeParcelable != null) {
                bundle.putString("expired_event_name", abstractSafeParcelable.zza);
                abstractSafeParcelable = abstractSafeParcelable.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzc());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    static {
        String[] stringArray = new String[]{"firebase_", "google_", "ga_"};
        zza = stringArray;
        stringArray = new String[]{"_err"};
        zzb = stringArray;
    }

    zzlb(zzfr object) {
        super((zzfr)object);
        this.zzd = object = new AtomicLong(0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzI(Bundle bundle, long l) {
        long l2;
        long l3 = bundle.getLong("_et");
        if (l3 != 0L) {
            this.zzt.zzay().zzk().zzb("Params already contained engagement", l3);
            l2 = l3;
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l + l2);
    }

    final void zzJ(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzlb.zzao(bundle, n)) {
            this.zzt.zzf();
            bundle.putString("_ev", this.zzD(string, 40, true));
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)object.toString().length());
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzK(zzie zzie2, Bundle bundle, boolean bl) {
        if (bundle != null && zzie2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzie2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzie2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzie2.zzc);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzie2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    final void zzL(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            this.zzt.zzv().zzO(bundle, string, bundle2.get(string));
        }
    }

    final void zzM(zzei zzei2, int n) {
        TreeSet treeSet = new TreeSet(zzei2.zzd.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzlb.zzai(string) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            this.zzt.zzay().zze().zzc(stringBuilder.toString(), this.zzt.zzj().zzd(zzei2.zza), this.zzt.zzj().zzb(zzei2.zzd));
            zzlb.zzao(zzei2.zzd, 5);
            zzei2.zzd.remove(string);
        }
    }

    final void zzN(zzla zzla2, String string, int n, String string2, String string3, int n2) {
        zzlb zzlb2 = new Bundle();
        zzlb.zzao((Bundle)zzlb2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzlb2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            zzlb2.putLong("_el", n2);
        }
        zzla2.zza(string, "_err", (Bundle)zzlb2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaA() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzt.zzay().zzk().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zzd.set(l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzO(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        this.zzt.zzay().zzl().zzc("Not putting event parameter. Invalid value type. name, type", this.zzt.zzj().zze((String)var2_5), var1_3);
    }

    public final void zzP(zzcf zzcf2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzQ(zzcf zzcf2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzR(zzcf zzcf2, Bundle bundle) {
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzS(zzcf zzcf2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzT(zzcf zzcf2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcf zzcf2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzV(zzcf zzcf2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzay().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzW(String string, String string2, String string3, Bundle bundle, List list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzt.zzf();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n2 = !bl ? this.zzj(string4) : 0;
                if (n2 == 0) {
                    n2 = this.zzi(string4);
                }
            } else {
                n2 = 0;
            }
            if (n2 != 0) {
                String string5 = n2 == 3 ? string4 : null;
                this.zzJ(bundle, n2, string4, string4, string5);
                bundle.remove(string4);
                continue;
            }
            if (this.zzaf(bundle.get(string4))) {
                this.zzt.zzay().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                this.zzJ(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzlb.zzai(string4) || zzlb.zzas(string4, zzgp.zzd) || ++n <= 0) continue;
            this.zzt.zzay().zze().zzc("Item cannot contain custom parameters", this.zzt.zzj().zzd(string2), this.zzt.zzj().zzb(bundle));
            zzlb.zzao(bundle, 23);
            bundle.remove(string4);
        }
        return;
    }

    private static boolean zzas(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzkz.zza(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzX(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzlb.zzap(string)) return true;
            if (!this.zzt.zzL()) return false;
            this.zzt.zzay().zze().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzeh.zzn(string));
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzlb.zzap(string2)) {
                return true;
            }
            this.zzt.zzay().zze().zzb("Invalid admob_app_id. Analytics disabled.", zzeh.zzn(string2));
            return false;
        }
        if (!this.zzt.zzL()) return false;
        this.zzt.zzay().zze().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzY(String string, int n, String string2) {
        if (string2 == null) {
            this.zzt.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            this.zzt.zzay().zze().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final boolean zzZ(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzt.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zza;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzt.zzay().zze().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzlb.zzas(string2, stringArray) && (stringArray2 == null || !zzlb.zzas(string2, stringArray2))) {
            this.zzt.zzay().zze().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzaa(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            if (((String)(object = object.toString())).codePointCount(0, ((String)object).length()) > n) {
                this.zzt.zzay().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, ((String)object).length());
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzab(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzt.zzay().zze().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzt.zzay().zze().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzt.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzt.zzay().zze().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzac(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzt.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzt.zzay().zze().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzt.zzay().zze().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzt.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    @WorkerThread
    final boolean zzad(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzt.zzau()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzt.zzay().zzc().zzb("Permission not granted", string);
        return false;
    }

    final boolean zzae(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object = this.zzt;
        object = ((zzfr)object).zzf();
        object = ((zzag)object).zzl();
        this.zzt.zzaw();
        return ((String)object).equals(string);
    }

    final boolean zzaf(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzag(Context signature, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        signature = Wrappers.packageManager((Context)signature).getPackageInfo((String)signatureArray, 64);
        if (signature == null) return true;
        signatureArray = signature.signatures;
        if (signatureArray == null) return true;
        int n = signature.signatures.length;
        if (n <= 0) return true;
        try {
            signature = signature.signatures;
            signature = signature[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature.toByteArray());
            return ((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream)).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzt.zzay().zzd().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzt.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    static boolean zzah(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzai(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzaj(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzat(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzak(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzlb.zzat(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzlb.zzat(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    public static boolean zzal(String string) {
        return !zzb[0].equals(string);
    }

    final boolean zzam(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    final byte[] zzan(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzlb zzlb2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzlb2, 0);
            object = zzlb2.marshall();
        }
        finally {
            zzlb2.recycle();
        }
        return object;
    }

    static final boolean zzao(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzap(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

