/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzgs;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfd
extends zzgs {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzfb zzb;
    public final zzez zzc;
    public final zzez zzd;
    public final zzfc zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzez zzf;
    public final zzex zzg;
    public final zzfc zzh;
    public final zzex zzi;
    public final zzez zzj;
    public boolean zzk;
    public final zzex zzl;
    public final zzex zzm;
    public final zzez zzn;
    public final zzfc zzo;
    public final zzfc zzp;
    public final zzez zzq;
    public final zzey zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzeb.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzfd(zzfy object) {
        super((zzfy)object);
        this.zzf = object = new zzez(this, "session_timeout", 1800000L);
        this.zzg = object = new zzex(this, "start_new_session", true);
        this.zzj = object = new zzez(this, "last_pause_time", 0L);
        this.zzh = object = new zzfc(this, "non_personalized_ads", null);
        this.zzi = object = new zzex(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzez(this, "first_open_time", 0L);
        this.zzd = object = new zzez(this, "app_install_time", 0L);
        this.zze = object = new zzfc(this, "app_instance_id", null);
        this.zzl = object = new zzex(this, "app_backgrounded", false);
        this.zzm = object = new zzex(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzez(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzfc(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzfc(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzez(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzey(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzfb zzfb2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzfb2 = new zzfb(this, "health_monitor", Math.max(0L, (Long)zzeb.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfd2.zzg();
        zzfd zzfd2 = zzfd2.zza().edit();
        if (bl != null) {
            zzfd2.putBoolean("measurement_enabled", bl);
        } else {
            zzfd2.remove("measurement_enabled");
        }
        zzfd2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzfd2.zzg();
        zzfd2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzfd zzfd2 = zzfd2.zza().edit();
        zzfd2.putBoolean("deferred_analytics_collection", bl);
        zzfd2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfd zzfd2 = zzfd2.zzt;
        if (zzfd2 == null) {
            return false;
        }
        return zzfd2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

