/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgy;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfj
extends zzgy {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzfh zzb;
    public final zzff zzc;
    public final zzff zzd;
    public final zzfi zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzff zzf;
    public final zzfd zzg;
    public final zzfi zzh;
    public final zzfd zzi;
    public final zzff zzj;
    public boolean zzk;
    public final zzfd zzl;
    public final zzfd zzm;
    public final zzff zzn;
    public final zzfi zzo;
    public final zzfi zzp;
    public final zzff zzq;
    public final zzfe zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzeh.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzfj(zzge object) {
        super((zzge)object);
        this.zzf = object = new zzff(this, "session_timeout", 1800000L);
        this.zzg = object = new zzfd(this, "start_new_session", true);
        this.zzj = object = new zzff(this, "last_pause_time", 0L);
        this.zzh = object = new zzfi(this, "non_personalized_ads", null);
        this.zzi = object = new zzfd(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzff(this, "first_open_time", 0L);
        this.zzd = object = new zzff(this, "app_install_time", 0L);
        this.zze = object = new zzfi(this, "app_instance_id", null);
        this.zzl = object = new zzfd(this, "app_backgrounded", false);
        this.zzm = object = new zzfd(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzff(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzfi(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzfi(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzff(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzfe(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzfh zzfh2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzfh2 = new zzfh(this, "health_monitor", Math.max(0L, (Long)zzeh.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfj2.zzg();
        zzfj zzfj2 = zzfj2.zza().edit();
        if (bl != null) {
            zzfj2.putBoolean("measurement_enabled", bl);
        } else {
            zzfj2.remove("measurement_enabled");
        }
        zzfj2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzfj2.zzg();
        zzfj2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzfj zzfj2 = zzfj2.zza().edit();
        zzfj2.putBoolean("deferred_analytics_collection", bl);
        zzfj2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfj zzfj2 = zzfj2.zzt;
        if (zzfj2 == null) {
            return false;
        }
        return zzfj2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

