/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzq;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzel
extends zzf {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private final long zzg;
    private List zzh;
    private String zzi;
    private int zzj;
    private String zzk;
    private String zzl;
    private String zzm;
    private long zzn = 0L;
    private String zzo = null;

    @WorkerThread
    final int zzh() {
        this.zza();
        return this.zzj;
    }

    @WorkerThread
    final int zzi() {
        this.zza();
        return this.zzc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final zzq zzj(String string) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        Object object3;
        long l;
        String string2;
        long l2;
        String string3;
        String string4;
        String string5;
        block30: {
            PackageManager packageManager;
            Object[] objectArray;
            block28: {
                long l3;
                block29: {
                    ((zzgx)object).zzg();
                    string5 = ((zzel)object).zzl();
                    string4 = ((zzel)object).zzm();
                    ((zzf)object).zza();
                    string3 = ((zzel)object).zzb;
                    ((zzf)object).zza();
                    l2 = ((zzel)object).zzc;
                    ((zzf)object).zza();
                    Preconditions.checkNotNull((Object)((zzel)object).zzd);
                    string2 = ((zzel)object).zzd;
                    ((zzgx)object).zzs.zzf().zzh();
                    ((zzf)object).zza();
                    ((zzgx)object).zzg();
                    l = ((zzel)object).zzf;
                    if (l != 0L) break block28;
                    zzln zzln2 = ((zzel)object).zzs.zzv();
                    object3 = ((zzgx)object).zzs.zzau();
                    objectArray = ((zzgx)object).zzs.zzau().getPackageName();
                    zzln2.zzg();
                    Preconditions.checkNotNull((Object)object3);
                    Preconditions.checkNotEmpty((String)objectArray);
                    packageManager = object3.getPackageManager();
                    MessageDigest messageDigest = zzln.zzF();
                    if (messageDigest == null) {
                        zzln2.zzs.zzay().zzd().zza("Could not get MD5 instance");
                        l3 = -1L;
                    } else {
                        if (packageManager != null) {
                            long l4;
                            boolean bl3 = zzln2.zzag((Context)object3, (String)objectArray);
                            if (!bl3) {
                                int n;
                                object3 = Wrappers.packageManager((Context)object3);
                                Signature[] signatureArray = zzln2.zzs.zzau();
                                object3 = object3.getPackageInfo(signatureArray.getPackageName(), 64);
                                signatureArray = ((PackageInfo)object3).signatures;
                                if (signatureArray != null && (n = ((PackageInfo)object3).signatures.length) > 0) {
                                    long l5;
                                    l4 = l5 = zzln.zzp(messageDigest.digest(((PackageInfo)object3).signatures[0].toByteArray()));
                                } else {
                                    object3 = zzln2.zzs.zzay();
                                    ((zzeu)object3).zzk().zza("Could not get signatures");
                                    l4 = -1L;
                                }
                            } else {
                                l4 = 0L;
                            }
                            l3 = l4;
                        }
                        l3 = 0L;
                    }
                    break block29;
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        zzln2.zzs.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
                        l3 = 0L;
                    }
                }
                ((zzel)object).zzf = l3;
                l = l3;
            }
            bl2 = ((zzel)object).zzs.zzJ();
            bl = ((zzgx)object).zzs.zzm().zzk ^ true;
            ((zzgx)object).zzg();
            if (!((zzel)object).zzs.zzJ()) {
                object2 = null;
            } else {
                zzpo.zzc();
                if (((zzgx)object).zzs.zzf().zzs(null, zzeh.zzaa)) {
                    ((zzgx)object).zzs.zzay().zzj().zza("Disabled IID for tests.");
                    object2 = null;
                } else {
                    block27: {
                        block26: {
                            object2 = ((zzgx)object).zzs.zzau();
                            object2 = object2.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                            if (object2 != null) break block26;
                            object2 = null;
                        }
                        object3 = new Class[]{Context.class};
                        object3 = ((Class)object2).getDeclaredMethod("getInstance", (Class<?>)object3);
                        objectArray = new Object[1];
                        packageManager = ((zzgx)object).zzs.zzau();
                        objectArray[0] = packageManager;
                        object3 = ((Method)object3).invoke(null, objectArray);
                        if (object3 != null) break block27;
                        object2 = null;
                    }
                    object2 = (String)((Class)object2).getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object3, new Object[0]);
                    catch (ClassNotFoundException classNotFoundException) {
                        object2 = null;
                    }
                }
            }
            break block30;
            catch (Exception exception) {
                ((zzgx)object).zzs.zzay().zzm().zza("Failed to obtain Firebase Analytics instance");
                object2 = null;
            }
            break block30;
            catch (Exception exception) {
                ((zzgx)object).zzs.zzay().zzl().zza("Failed to retrieve Firebase Instance Id");
                object2 = null;
            }
        }
        object3 = ((zzel)object).zzs;
        long l6 = ((zzge)object3).zzm().zzc.zza();
        long l7 = l6 == 0L ? (l6 = ((zzge)object3).zzc) : (l6 = Math.min(((zzge)object3).zzc, l6));
        ((zzf)object).zza();
        int n = ((zzel)object).zzj;
        boolean bl4 = ((zzgx)object).zzs.zzf().zzr();
        object3 = ((zzgx)object).zzs.zzm();
        ((zzgx)object3).zzg();
        boolean bl5 = ((zzfj)object3).zza().getBoolean("deferred_analytics_collection", false);
        ((zzf)object).zza();
        String string6 = ((zzel)object).zzl;
        object3 = ((zzgx)object).zzs.zzf().zzk("google_analytics_default_allow_ad_personalization_signals");
        object3 = object3 == null ? null : Boolean.valueOf((Boolean)object3 ^ true);
        long l8 = ((zzel)object).zzg;
        List list = ((zzel)object).zzh;
        String string7 = ((zzgx)object).zzs.zzm().zzc().zzh();
        if (((zzel)object).zzi == null) {
            ((zzel)object).zzi = ((zzgx)object).zzs.zzf().zzs(null, zzeh.zzaE) ? ((zzgx)object).zzs.zzv().zzC() : "";
        }
        String string8 = ((zzel)object).zzi;
        zzpi.zzc();
        if (((zzgx)object).zzs.zzf().zzs(null, zzeh.zzaz)) {
            ((zzgx)object).zzg();
            if (((zzel)object).zzn != 0L) {
                long l9 = ((zzgx)object).zzs.zzav().currentTimeMillis() - ((zzel)object).zzn;
                if (((zzel)object).zzm != null && l9 > 86400000L && ((zzel)object).zzo == null) {
                    ((zzel)object).zzo();
                }
            }
            if (((zzel)object).zzm == null) {
                ((zzel)object).zzo();
            }
            object = ((zzel)object).zzm;
            return new zzq(string5, string4, string3, l2, string2, 68000L, l, string, bl2, bl, (String)object2, 0L, l7, n, bl4, bl5, string6, (Boolean)object3, l8, list, null, string7, string8, (String)object);
        } else {
            object = null;
        }
        return new zzq(string5, string4, string3, l2, string2, 68000L, l, string, bl2, bl, (String)object2, 0L, l7, n, bl4, bl5, string6, (Boolean)object3, l8, list, null, string7, string8, (String)object);
    }

    @WorkerThread
    final String zzk() {
        this.zza();
        return this.zzl;
    }

    @WorkerThread
    final String zzl() {
        this.zza();
        Preconditions.checkNotNull((Object)this.zza);
        return this.zza;
    }

    @WorkerThread
    final String zzm() {
        ((zzgx)this).zzg();
        this.zza();
        Preconditions.checkNotNull((Object)this.zzk);
        return this.zzk;
    }

    @WorkerThread
    final List zzn() {
        return this.zzh;
    }

    zzel(zzge zzge2, long l) {
        super(zzge2);
        this.zzg = l;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    @WorkerThread
    protected final void zzd() {
        block36: {
            block37: {
                var6_1 = this.zzs.zzau().getPackageName();
                var7_2 = this.zzs.zzau().getPackageManager();
                var1_3 = "unknown";
                var3_14 = "Unknown";
                var5_18 /* !! */  = "Unknown";
                if (var7_2 == null) {
                    this.zzs.zzay().zzd().zzb("PackageManager is null, app identity information might be inaccurate. appId", zzeu.zzn(var6_1));
                    var2_20 = var3_14;
                    var3_15 = -2147483648;
                    var4_24 /* !! */  = var5_18 /* !! */ ;
                } else {
                    block34: {
                        block33: {
                            try {
                                var2_20 = var7_2.getInstallerPackageName(var6_1);
                                var1_3 = var2_20;
                            }
                            catch (IllegalArgumentException v0) {
                                this.zzs.zzay().zzd().zzb("Error retrieving app installer package name. appId", zzeu.zzn(var6_1));
                            }
                            if (var1_3 == null) {
                                var1_3 = "manual_install";
                            } else if ("com.android.vending".equals(var1_3)) {
                                var1_3 = "";
                            }
                            var2_20 = this.zzs.zzau();
                            var4_24 /* !! */  = var7_2.getPackageInfo(var2_20.getPackageName(), 0);
                            if (var4_24 /* !! */  == null) break block33;
                            var2_20 = var7_2.getApplicationLabel(var4_24 /* !! */ .applicationInfo);
                            var8_26 = TextUtils.isEmpty((CharSequence)var2_20);
                            var2_20 = var8_26 == false ? var2_20.toString() : var5_18 /* !! */ ;
                            var5_18 /* !! */  = var4_24 /* !! */ .versionName;
                            var4_25 = var4_24 /* !! */ .versionCode;
                            var3_14 = var5_18 /* !! */ ;
                            var5_18 /* !! */  = var2_20;
                            break block34;
                        }
                        var4_25 = -2147483648;
                    }
                    var2_20 = var3_14;
                    var3_15 = var4_25;
                    var4_24 /* !! */  = var5_18 /* !! */ ;
                }
                break block37;
                catch (PackageManager.NameNotFoundException v1) {
                    block35: {
                        var4_24 /* !! */  = var5_18 /* !! */ ;
                        break block35;
                        catch (PackageManager.NameNotFoundException v2) {
                            var4_24 /* !! */  = var2_20;
                            break block35;
                        }
                        catch (PackageManager.NameNotFoundException v3) {
                            var3_14 = var5_18 /* !! */ ;
                            var4_24 /* !! */  = var2_20;
                        }
                    }
                    this.zzs.zzay().zzd().zzc("Error retrieving package info. appId, appName", zzeu.zzn(var6_1), var4_24 /* !! */ );
                    var2_20 = var3_14;
                    var3_15 = -2147483648;
                }
            }
            this.zza = var6_1;
            this.zzd = var1_3;
            this.zzb = var2_20;
            this.zzc = var3_15;
            this.zze = var4_24 /* !! */ ;
            this.zzf = 0L;
            var1_4 = !TextUtils.isEmpty((CharSequence)this.zzs.zzw()) ? "am".equals(this.zzs.zzx()) : false;
            var2_21 = this.zzs.zza();
            switch (var2_21) {
                default: {
                    this.zzs.zzay().zzi().zza("App measurement disabled due to denied storage consent");
                    break;
                }
                case 0: {
                    this.zzs.zzay().zzj().zza("App measurement collection enabled");
                    break;
                }
                case 1: {
                    this.zzs.zzay().zzi().zza("App measurement deactivated via the manifest");
                    break;
                }
                case 2: {
                    this.zzs.zzay().zzj().zza("App measurement deactivated via the init parameters");
                    break;
                }
                case 3: {
                    this.zzs.zzay().zzi().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                    break;
                }
                case 4: {
                    this.zzs.zzay().zzi().zza("App measurement disabled via the manifest");
                    break;
                }
                case 5: {
                    this.zzs.zzay().zzj().zza("App measurement disabled via the init parameters");
                    break;
                }
                case 6: {
                    this.zzs.zzay().zzl().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                    break;
                }
                case 7: {
                    this.zzs.zzay().zzi().zza("App measurement disabled via the global data collection setting");
                }
            }
            this.zzk = "";
            this.zzl = "";
            this.zzs.zzaw();
            if (var1_4) {
                this.zzl = this.zzs.zzw();
            }
            try {
                var1_5 = this.zzs.zzau();
                var3_16 = this.zzs.zzz();
                var3_16 = zzip.zzc((Context)var1_5, (String)"google_app_id", (String)var3_16);
                var1_6 = TextUtils.isEmpty((CharSequence)var3_16);
                var1_7 = true != var1_6 ? var3_16 : "";
                this.zzk = var1_7;
                var1_8 = TextUtils.isEmpty((CharSequence)var3_16);
                if (!var1_8) {
                    var1_9 /* !! */  = this.zzs.zzau();
                    var3_16 = this.zzs.zzz();
                    Preconditions.checkNotNull((Object)var1_9 /* !! */ );
                    var4_24 /* !! */  = var1_9 /* !! */ .getResources();
                    var5_19 = TextUtils.isEmpty((CharSequence)var3_16);
                    var1_9 /* !! */  = var5_19 == false ? var3_16 : zzfw.zza((Context)var1_9 /* !! */ );
                    this.zzl = zzfw.zzb((String)"admob_app_id", (Resources)var4_24 /* !! */ , (String)var1_9 /* !! */ );
                }
                if (var2_21 == 0) {
                    var1_10 = this.zzs.zzay();
                    var2_22 = var1_10.zzj();
                    var3_16 = "App measurement enabled for app package, google app id";
                    var4_24 /* !! */  = this.zza;
                    var1_4 = TextUtils.isEmpty((CharSequence)this.zzk);
                    var1_11 = var1_4 != false ? this.zzl : this.zzk;
                    var2_22.zzc(var3_16, var4_24 /* !! */ , var1_11);
                }
            }
            catch (IllegalStateException var1_13) {
                this.zzs.zzay().zzd().zzc("Fetching Google App Id failed with exception. appId", zzeu.zzn(var6_1), var1_13);
            }
            this.zzh = null;
            this.zzs.zzaw();
            var1_12 = this.zzs.zzf().zzp("analytics.safelisted_events");
            if (var1_12 == null) ** GOTO lbl139
            if (var1_12.isEmpty()) {
                this.zzs.zzay().zzl().zza("Safelisted event list is empty. Ignoring");
            } else {
                for (E var3_17 : var1_12) {
                    var3_17 /* !! */  = (String)var3_17 /* !! */ ;
                    if (this.zzs.zzv().zzab("safelisted event", (String)var3_17 /* !! */ )) continue;
                    break block36;
                }
lbl139:
                // 2 sources

                this.zzh = var1_12;
            }
        }
        if (var7_2 != null) {
            this.zzj = (int)InstantApps.isInstantApp((Context)this.zzs.zzau());
            return;
        }
        this.zzj = 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzo() {
        void var1_2;
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        ((zzgx)this).zzg();
        if (!this.zzs.zzm().zzc().zzi(zzah.zzb)) {
            this.zzs.zzay().zzc().zza("Analytics Storage consent is not granted");
            Object var1_1 = null;
        } else {
            byte[] byArray = new byte[16];
            this.zzs.zzv().zzG().nextBytes(byArray);
            object = Locale.US;
            objectArray2 = new BigInteger(1, byArray);
            objectArray = new Object[]{objectArray2};
            String string = String.format((Locale)object, "%032x", objectArray);
        }
        objectArray = this.zzs.zzay().zzc();
        objectArray2 = new Object[1];
        object = var1_2 == null ? "null" : "not null";
        objectArray2[0] = object;
        objectArray.zza(String.format("Resetting session stitching token to %s", objectArray2));
        this.zzm = var1_2;
        this.zzn = this.zzs.zzav().currentTimeMillis();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzp(String string) {
        String string2 = this.zzo;
        boolean bl = string2 != null ? !string2.equals(string) : false;
        this.zzo = string;
        return bl;
    }
}

